/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers.cards;

import com.rits.cloning.Cloner;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.Card;
import ru.ssa.cashadmin.domain.CardRange;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.cards.MassCreateForCardDialog;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.utils.InfoMessageFactory;
import su.artix.discountmanager.utils.MultiLineDialogOperations;
import su.artix.discountmanager.utils.MultiLineMessages;
import su.artix.yuki.model.directory.DirectoryEditModel;
import su.artix.yuki.model.directory.DirectoryModelFactory;

public class MassCardCreateAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(MassCardCreateAction.class);

    public ImageDescriptor getImageDescriptor() {
        return ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/cards_mass_create.png");
    }

    public String getText() {
        return "\u041c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435";
    }

    public String getToolTipText() {
        return "\u041c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435";
    }

    public void run() {
        MassCreateForCardDialog dlg = new MassCreateForCardDialog();
        if (dlg.open() == 0) {
            final Card cardModel = dlg.getCardModel();
            final CardRange cardRange = dlg.getCardRangeModel();
            Activator.getDefault().setLoadCursor(true);
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (selection instanceof StructuredSelection) {
                final AtomicBoolean abortCommand = new AtomicBoolean(false);
                MultiLineDialogOperations cardMessageOperations = new MultiLineDialogOperations(){

                    @Override
                    public void abortOperation() {
                        abortCommand.set(true);
                    }
                };
                final MultiLineMessages messages = InfoMessageFactory.multiLineInfoMessage(cardMessageOperations);
                ArtixAdminContextHolder.getConnectionId();
                final String connectionId = ArtixAdminContextHolder.getConnectionId();
                Thread createCardsThread = new Thread("CardChangedThread"){

                    @Override
                    public void run() {
                        ArtixAdminContextHolder.setConnectionId((String)connectionId);
                        boolean errorExist = false;
                        DirectoryEditModel directoryModel = DirectoryModelFactory.getModel(Card.class);
                        if (cardRange != null) {
                            int i = cardRange.getBegin();
                            while (i <= cardRange.getEnd()) {
                                String cardNumber = cardRange.getGeneratedNumber(i);
                                try {
                                    if (abortCommand.get()) break;
                                    Cloner cloner = new Cloner();
                                    cloner.dontCloneInstanceOf(new Class[]{PropertyChangeSupport.class});
                                    Card newCard = (Card)cloner.deepClone((Object)cardModel);
                                    newCard.setNumber(cardNumber);
                                    directoryModel.save((Object)newCard);
                                    messages.addMessage("\u041a\u0430\u0440\u0442\u0430 \u2116: " + newCard.getNumber() + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                    errorExist = true;
                                    messages.addMessage("\u041a\u0430\u0440\u0442\u0430 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + cardNumber + " \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0430: " + e.getMessage());
                                }
                                i += cardRange.getStep();
                            }
                        }
                        directoryModel.doRefresh();
                        messages.lastMessage(errorExist ? "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438" : "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0431\u0435\u0437 \u043e\u0448\u0438\u0431\u043e\u043a");
                    }
                };
                createCardsThread.start();
                Activator.getDefault().setLoadCursor(false);
            }
        }
    }
}

