/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.providers.menu.sourcesystem.PasteProvider;
import su.artix.discountmanager.transfer.ObjectTransfer;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanager.utils.InfoMessageFactory;
import su.artix.discountmanager.utils.QuestionMessageFactory;
import su.artix.loyaltylib.domain.java.discountsystem.Counter;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.loyaltylib.domain.java.discountsystem.Gift;
import su.artix.loyaltylib.domain.java.discountsystem.Report;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.loyaltylib.domain.java.observable.AutoincCodes;
import su.artix.loyaltylib.domain.java.observable.Named;

public class PasteHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(PasteHandler.class);
    private Object destObject;
    private Object srcObject;
    private Clipboard clipboard = new Clipboard(Display.getCurrent());
    private DiscountSystemContentProvider systemContentProvider;
    private ISourceProviderService sourceProviderService = (ISourceProviderService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ISourceProviderService.class);

    private void updatePropertyChangeListener(Object object) {
        try {
            this.systemContentProvider.addListenerTo((AbstractDiscountModel)object);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void updateDiscountCampaignGroup(DiscountCampaignGroup destGroup, DiscountCampaignGroup srcGroup) {
        this.updatePropertyChangeListener(srcGroup);
        if (!srcGroup.getSubGroups().isEmpty()) {
            for (DiscountCampaignGroup group : srcGroup.getSubGroups()) {
                group.setParent((Named)srcGroup);
                this.updateDiscountCampaignGroup(destGroup, group);
            }
        }
        if (!srcGroup.getDiscountCampaigns().isEmpty()) {
            for (DiscountCampaign campaign : srcGroup.getDiscountCampaigns()) {
                campaign.setParent((Named)srcGroup);
                this.updateDiscountCampaign(destGroup, campaign);
            }
        }
    }

    private void updateDiscountCampaign(DiscountCampaignGroup destGroup, DiscountCampaign srcCampaign) {
        this.updatePropertyChangeListener(srcCampaign);
        if (destGroup != null && this.checkDiscountCampaign(destGroup, srcCampaign)) {
            this.changeCodeSilent(srcCampaign);
        }
        if (!srcCampaign.getDiscounts().isEmpty()) {
            for (Discount discount : srcCampaign.getDiscounts()) {
                discount.setParent((Named)srcCampaign);
                this.updateDiscount(destGroup, discount);
            }
        }
    }

    private void updateDiscount(DiscountCampaignGroup destGroup, Discount srcDiscount) {
        this.updatePropertyChangeListener(srcDiscount);
        if (destGroup != null && this.checkDiscount(destGroup, srcDiscount)) {
            this.changeCodeSilent(srcDiscount);
        }
        if (srcDiscount.getDiscountObject() != null) {
            this.updateDiscountObject(srcDiscount, srcDiscount.getDiscountObject());
        }
        if (!srcDiscount.getDiscountConditions().isEmpty()) {
            for (DiscountCondition condition : srcDiscount.getDiscountConditions()) {
                this.updateDiscountCondition(srcDiscount, condition);
            }
        }
        if (srcDiscount.getDiscountRate() != null) {
            this.updateDiscountRate(srcDiscount, srcDiscount.getDiscountRate());
        }
        if (CollectionUtils.isNotEmpty((Collection)srcDiscount.getCounters())) {
            for (Counter counter : srcDiscount.getCounters()) {
                this.updateCounter(srcDiscount, counter);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)srcDiscount.getGifts())) {
            for (Gift gift : srcDiscount.getGifts()) {
                this.updateGift(srcDiscount, gift);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)srcDiscount.getReports())) {
            for (Report report : srcDiscount.getReports()) {
                this.updateReport(srcDiscount, report);
            }
        }
    }

    private void updateDiscountObject(Discount parentDiscount, DiscountObject srcObject) {
        srcObject.setParent((Named)parentDiscount);
        this.updatePropertyChangeListener(srcObject);
    }

    private void updateDiscountCondition(Discount parentDiscount, DiscountCondition srcCondition) {
        srcCondition.setParent(parentDiscount);
        this.updatePropertyChangeListener(srcCondition);
    }

    private void updateDiscountRate(Discount parentDiscount, DiscountRate scrRate) {
        scrRate.setParent((Named)parentDiscount);
        this.updatePropertyChangeListener(scrRate);
    }

    private void updateCounter(Discount parentDiscount, Counter counter) {
        counter.setParent((Named)parentDiscount);
        this.updatePropertyChangeListener(counter);
    }

    private void updateGift(Discount parentDiscount, Gift gift) {
        gift.setParent((Named)parentDiscount);
        this.updatePropertyChangeListener(gift);
    }

    private void updateReport(Discount parentDiscount, Report report) {
        report.setParent((Named)parentDiscount);
        this.updatePropertyChangeListener(report);
    }

    private boolean checkDiscountCampaign(DiscountCampaignGroup parent, DiscountCampaign child) {
        return AutoincCodes.checkCodesDiscountCampaign((DiscountCampaignGroup)parent, (Long)child.getId());
    }

    private boolean checkDiscount(DiscountCampaignGroup parent, Discount child) {
        return !parent.getDiscountCampaigns().isEmpty() && AutoincCodes.checkCodesDiscount((DiscountCampaign)((DiscountCampaign)parent.getDiscountCampaigns().get(0)), (Long)child.getId());
    }

    private Object changeCodeSilent(Object child) {
        AtomicLong next = Activator.getDefault().next(this.systemContentProvider.getSystemType());
        if (child instanceof DiscountCampaign) {
            DiscountCampaign campaign = (DiscountCampaign)child;
            for (Discount discount : campaign.getDiscounts()) {
                discount.setId(Long.valueOf(next.getAndIncrement()));
                discount.setParent((Named)campaign);
                discount.getDiscountRate().setParent((Named)discount);
                discount.getDiscountObject().setParent((Named)discount);
            }
            campaign.setId(Long.valueOf(next.getAndIncrement()));
        } else if (child instanceof Discount) {
            ((Discount)child).setId(Long.valueOf(next.getAndIncrement()));
        }
        return child;
    }

    public void dispose() {
        this.clipboard.dispose();
        super.dispose();
    }

    private PasteProvider getPasteProvider(String sourceName) {
        return (PasteProvider)this.sourceProviderService.getSourceProvider(sourceName);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.destObject = ViewHolder.INSTANCE.getSelectionElementFromActiveView();
        this.srcObject = this.clipboard.getContents((Transfer)ObjectTransfer.getInstance());
        String warningMessage = this.getPasteProvider("su.artix.discountmanager.providers.menu.pasteEnabled").getWarningMessage();
        if (warningMessage != null) {
            InfoMessageFactory.copyTreeItemWarningMessage(warningMessage);
        } else {
            TreeViewer treeViewer = (TreeViewer)ViewHolder.INSTANCE.getActiveViewPart().getSite().getSelectionProvider();
            this.systemContentProvider = (DiscountSystemContentProvider)treeViewer.getContentProvider();
            if (this.srcObject instanceof DiscountCampaignGroup) {
                DiscountCampaignGroup srcGroup = (DiscountCampaignGroup)this.srcObject;
                if (this.destObject instanceof DiscountCampaignGroup) {
                    DiscountCampaignGroup destGroup = (DiscountCampaignGroup)this.destObject;
                    this.updateDiscountCampaignGroup(destGroup, srcGroup);
                    destGroup.addSubGroup(srcGroup);
                } else if (this.destObject instanceof DiscountSystem) {
                    DiscountSystem destSystem = (DiscountSystem)this.destObject;
                    if (destSystem.getCampaignGroup() == null) {
                        this.updateDiscountCampaignGroup(null, srcGroup);
                        destSystem.setCampaignGroup(srcGroup);
                        srcGroup.setParent((Named)destSystem);
                    } else {
                        ErrorMessageFactory.generalErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430", "\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0433\u0440\u0443\u043f\u043f\u0443!");
                    }
                }
            } else if (this.srcObject instanceof DiscountCampaign) {
                DiscountCampaign srcCampaign = (DiscountCampaign)this.srcObject;
                DiscountCampaignGroup destGroup = (DiscountCampaignGroup)this.destObject;
                this.updateDiscountCampaign(destGroup, srcCampaign);
                destGroup.addDiscountCampaign(srcCampaign);
            } else if (this.srcObject instanceof Discount) {
                Discount srcDiscount = (Discount)this.srcObject;
                DiscountCampaign destCampaign = (DiscountCampaign)this.destObject;
                this.updateDiscount((DiscountCampaignGroup)destCampaign.getParent(), srcDiscount);
                destCampaign.addDiscount(srcDiscount);
            } else if (this.srcObject instanceof DiscountObject) {
                DiscountObject srcDiscountObject = (DiscountObject)this.srcObject;
                Discount destDiscount = (Discount)this.destObject;
                this.updateDiscountObject(destDiscount, srcDiscountObject);
                if (destDiscount.getDiscountObject() != null) {
                    if (QuestionMessageFactory.changeObjectQuestionMessage()) {
                        destDiscount.deleteDiscountObject();
                        destDiscount.addDiscountObject(srcDiscountObject);
                    }
                } else {
                    destDiscount.addDiscountObject(srcDiscountObject);
                }
            } else if (this.srcObject instanceof DiscountCondition) {
                DiscountCondition srcCondition = (DiscountCondition)this.srcObject;
                Discount destDiscount = (Discount)this.destObject;
                this.updateDiscountCondition(destDiscount, srcCondition);
                destDiscount.addDiscountCondition(srcCondition);
            } else if (this.srcObject instanceof DiscountRate && QuestionMessageFactory.changeObjectQuestionMessage()) {
                DiscountRate srcRate = (DiscountRate)this.srcObject;
                Discount destDiscount = (Discount)this.destObject;
                this.updateDiscountRate(destDiscount, srcRate);
                destDiscount.setDiscountRate(srcRate);
            }
        }
        return null;
    }
}

