/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.discountmanagercore.holders.PropertiesHolder;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;

public class ExportSystemHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ExportSystemHandler.class);

    private DiscountSystemContentProvider getProvider() {
        TreeViewer systemTree = (TreeViewer)ViewHolder.INSTANCE.getActiveViewPart().getSite().getSelectionProvider();
        return (DiscountSystemContentProvider)systemTree.getContentProvider();
    }

    protected void saveDiscountModelToFile(List<AbstractDiscountModel> models) {
        block10: {
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            String[] filterExtensions = new String[]{"*.yaml"};
            String filterPath = PropertiesHolder.INSTANCE.getCommonsProperty("DISCOUNT.PATHTOEXPORTEDFILELIN", "/");
            String platform = SWT.getPlatform();
            if (platform.equals("win32") || platform.equals("wpf")) {
                filterPath = PropertiesHolder.INSTANCE.getCommonsProperty("DISCOUNT.PATHTOEXPORTEDFILEWIN", "C:\\");
                filterExtensions = new String[]{"*.yaml"};
            }
            dialog.setFilterExtensions(filterExtensions);
            dialog.setFilterPath(filterPath);
            String file = dialog.open();
            if (file != null) {
                try {
                    try {
                        Activator.getDefault().setLoadCursor(true);
                        DiscountSystemDAO discountSystemDAO = Activator.getDefault().getBeanByClass(DiscountSystemDAO.class);
                        if (models.size() == 1 && models.get(0) instanceof DiscountSystem) {
                            discountSystemDAO.saveSystemToFile(file, (DiscountSystem)models.get(0));
                        } else {
                            discountSystemDAO.saveDiscountSubTreeToFile(file, models);
                        }
                        if (platform.equals("win32") || platform.equals("wpf")) {
                            PropertiesHolder.INSTANCE.setCommonsProperty("DISCOUNT.PATHTOEXPORTEDFILEWIN", file);
                            break block10;
                        }
                        PropertiesHolder.INSTANCE.setCommonsProperty("DISCOUNT.PATHTOEXPORTEDFILELIN", file);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        ErrorMessageFactory.exceptionMessage(e);
                        Activator.getDefault().setLoadCursor(false);
                    }
                }
                finally {
                    Activator.getDefault().setLoadCursor(false);
                }
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String idShop = ArtixAdminContextHolder.getConnectionId();
        ArrayList<AbstractDiscountModel> discountSystem = new ArrayList<AbstractDiscountModel>(1);
        discountSystem.add((AbstractDiscountModel)this.getProvider().getMap().get(idShop));
        this.saveDiscountModelToFile(discountSystem);
        return null;
    }
}

