/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.wizard;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.discountsystem.wizard.DiscountConditionWizardCheckConstructorPage;
import su.artix.discountmanager.dialogs.discountsystem.wizard.DiscountConditionWizardCheckFilledTemplatePage;
import su.artix.discountmanager.dialogs.discountsystem.wizard.DiscountConditionWizardConstructorPage;
import su.artix.discountmanager.dialogs.discountsystem.wizard.DiscountConditionWizardFillTemplatePage;
import su.artix.discountmanager.dialogs.discountsystem.wizard.DiscountConditionWizardSelectTemplatePage;
import su.artix.discountmanager.dialogs.discountsystem.wizard.DiscountConditionsFirstWizardPage;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.yuki.discount.condition.constructor.dao.ConstructorTreeProcessor;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplate;
import su.artix.yuki.discount.condition.template.dao.ConditionTemplateDAO;

public class DiscountConditionListWizard
extends Wizard {
    private Discount discount;
    private DiscountConditionsFirstWizardPage selectWayPage;
    private DiscountConditionWizardSelectTemplatePage templatesListPage;
    private DiscountConditionWizardFillTemplatePage fillTemplatePage;
    private DiscountConditionWizardCheckFilledTemplatePage checkFilledTemplatePage;
    private DiscountConditionWizardConstructorPage constructorPage;
    private DiscountConditionWizardCheckConstructorPage checkConstructorConditionPage;

    public DiscountConditionListWizard(Discount discount) {
        this.discount = discount;
        ConditionTemplateDAO discountTemplateDAO = Activator.getDefault().getBeanByClass(ConditionTemplateDAO.class);
        ConstructorTreeProcessor processor = Activator.getDefault().getBeanByClass(ConstructorTreeProcessor.class, "treeProcessorImpl");
        this.selectWayPage = new DiscountConditionsFirstWizardPage("\u0421\u043f\u043e\u0441\u043e\u0431 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u044f");
        this.templatesListPage = new DiscountConditionWizardSelectTemplatePage("\u0412\u044b\u0431\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430", discount, discountTemplateDAO);
        this.fillTemplatePage = new DiscountConditionWizardFillTemplatePage("\u0417\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430");
        this.checkFilledTemplatePage = new DiscountConditionWizardCheckFilledTemplatePage("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435");
        this.constructorPage = new DiscountConditionWizardConstructorPage("\u041a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440 \u0443\u0441\u043b\u043e\u0432\u0438\u044f", discount, processor);
        this.checkConstructorConditionPage = new DiscountConditionWizardCheckConstructorPage("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435");
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        DiscountCondition condition = null;
        if (currentPage == this.selectWayPage || currentPage == this.templatesListPage) {
            return false;
        }
        if (currentPage == this.fillTemplatePage) {
            condition = this.fillTemplatePage.get();
        } else if (currentPage == this.checkFilledTemplatePage) {
            condition = this.checkFilledTemplatePage.getCondition();
        } else if (currentPage == this.constructorPage) {
            condition = this.constructorPage.getDiscountCondition();
        } else if (currentPage == this.checkConstructorConditionPage) {
            condition = this.checkConstructorConditionPage.getCondition();
        }
        if (condition != null) {
            this.discount.getDiscountConditions().add(condition);
            StringBuilder sb = new StringBuilder();
            sb.append("cond=");
            sb.append(condition.getCondition());
            sb.append(" ");
            sb.append("desc=");
            sb.append(condition.getDescription());
            sb.append(" ");
            sb.append("tree name=");
            sb.append(condition.getNameTreeNode());
            sb.append(" ");
            sb.append("temp definition=");
            sb.append(condition.getTemplate().getDefinition());
            sb.append(" ");
            sb.append("temp spec=");
            sb.append(condition.getTemplate().getSpecification());
            sb.append(" ");
            sb.append("temp values=");
            sb.append(condition.getTemplate().getValues());
            System.out.println(sb.toString());
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.selectWayPage);
        this.addPage((IWizardPage)this.templatesListPage);
        this.addPage((IWizardPage)this.fillTemplatePage);
        this.addPage((IWizardPage)this.checkFilledTemplatePage);
        this.addPage((IWizardPage)this.constructorPage);
        this.addPage((IWizardPage)this.checkConstructorConditionPage);
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage == this.selectWayPage) {
            if (this.selectWayPage.isTemplateSelected()) {
                return this.templatesListPage;
            }
            return this.constructorPage;
        }
        if (currentPage == this.templatesListPage) {
            ConditionTemplate template = this.templatesListPage.getTemplate();
            if (template != null) {
                this.fillTemplatePage.update(template);
            }
            return this.fillTemplatePage;
        }
        if (currentPage == this.fillTemplatePage) {
            this.checkFilledTemplatePage.display(this.fillTemplatePage.get());
            return this.checkFilledTemplatePage;
        }
        if (currentPage == this.constructorPage) {
            this.checkConstructorConditionPage.display(this.constructorPage.getDiscountCondition());
            return this.checkConstructorConditionPage;
        }
        return null;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() != this.selectWayPage && this.getContainer().getCurrentPage() != this.templatesListPage;
    }
}

