/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.SystemTitleAreaDialog;
import su.artix.discountmanager.dialogs.discountsystem.DiscountObjectKitPanel;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanager.utils.FieldsUtils;
import su.artix.discountmanager.utils.QuestionMessageFactory;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKitItem;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitItem;
import su.artix.loyaltylib.domain.java.observable.Named;
import su.artix.yuki.editors.DialogMode;

@SecurityKey(title="\u041d\u0430\u0431\u043e\u0440\u044b \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432")
public class DiscountObjectKitDialog
extends SystemTitleAreaDialog {
    private DiscountObjectKit discountObjectKit;
    private DiscountObjectKitPanel discountObjectKitPanel;
    private boolean confirmCancel;
    private List<DiscountRateKitItem> resultRated;
    private List<DiscountObjectKitItem> resultKit;

    public DiscountObjectKitDialog(DiscountObjectKit discountObject, Map<String, String> paramList, DialogMode dialogMode) {
        super(Display.getCurrent().getActiveShell(), dialogMode, paramList);
        this.discountObjectKit = discountObject;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.confirmCancel = preferenceStore.getBoolean("CONFIRM_CANCEL_FOR_COMPLEX_DIALOG");
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    @Override
    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.fillTitleHeader(this.discountObjectKit.getParent(), (Named)this.discountObjectKit);
        return content;
    }

    @Override
    public void applyRights(String selector) {
        this.discountObjectKitPanel.applyRights(selector);
        super.applyRights(selector);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.discountObjectKitPanel = new DiscountObjectKitPanel(container, 0, DiscountObjectKit.class, this.discountObjectKit);
        this.discountObjectKitPanel.initialize();
        return container;
    }

    private void fillResultRatesAndKits() {
        this.resultRated = new ArrayList<DiscountRateKitItem>();
        this.resultKit = new ArrayList<DiscountObjectKitItem>();
        for (DiscountRateKitItem item : this.discountObjectKitPanel.getRatedItems()) {
            if (item.getDiscountRate() != null) {
                this.resultRated.add(item);
            }
            this.resultKit.add(item.getDiscountObjectKitItem());
        }
    }

    protected void okPressed() {
        DiscountObjectKit model = (DiscountObjectKit)this.discountObjectKitPanel.getModel();
        if (model.getName() == null || model.getName().isEmpty()) {
            ErrorMessageFactory.emptyFieldMessage();
        } else {
            Discount currentDiscount = (Discount)this.discountObjectKit.getParent();
            FieldsUtils.copyOnlyAnnotatedProperties(model, this.discountObjectKit, DiscountObjectKitPanel.class);
            this.fillResultRatesAndKits();
            this.discountObjectKit.setListKitItems(this.resultKit);
            ((DiscountRateKit)currentDiscount.getDiscountRate()).setKitItems(this.resultRated);
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        if (this.confirmCancel) {
            if (!this.discountObjectKit.equals(this.discountObjectKitPanel.getModel())) {
                if (QuestionMessageFactory.cancelQuestionMessage()) {
                    super.cancelPressed();
                }
            } else {
                this.fillResultRatesAndKits();
                if (!((DiscountRateKit)((Discount)this.discountObjectKit.getParent()).getDiscountRate()).getKitItems().equals(this.resultRated) || !this.discountObjectKit.getListKitItems().equals(this.resultKit)) {
                    if (QuestionMessageFactory.cancelQuestionMessage()) {
                        super.cancelPressed();
                    }
                } else {
                    super.cancelPressed();
                }
            }
        } else {
            super.cancelPressed();
        }
    }
}

