/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import ru.ssa.cashadmin.LibActivator;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.dialogs.SystemTitleAreaDialog;
import su.artix.discountmanager.dialogs.discountsystem.DiscountCampaignBonusesPanel;
import su.artix.discountmanager.dialogs.discountsystem.DiscountCampaignPanel;
import su.artix.discountmanager.dialogs.discountsystem.DiscountCampaignTagsPanel;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanager.utils.FieldsUtils;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;
import su.artix.loyaltylib.domain.java.observable.AutoincCodes;
import su.artix.loyaltylib.domain.java.observable.Named;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.MyKeyValue;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.EditorComposite;

@SecurityKey(title="\u0410\u043a\u0446\u0438\u0438 \u0441\u043a\u0438\u0434\u043e\u043a")
public class DiscountCampaignDialog
extends SystemTitleAreaDialog {
    private DiscountCampaign discountCampaign;
    private DiscountCampaignGroup parentGroup;
    private boolean isShowTimeLiveForDiscSystem = Boolean.getBoolean("discount.system.showTimeLive");
    private boolean isBonusEarnSystem = false;
    private DiscountSystemDAO.SystemType type;
    private List<EditorComposite<?>> childPanels;
    private EditorComposite<DiscountCampaign> basicPanel;
    private EditorComposite<DiscountCampaign> bonusesPanel;
    private EditorComposite<DiscountCampaign> tagsPanel;

    public DiscountCampaignDialog(DiscountCampaignGroup parentGroup, DiscountCampaign discountCampaign, Map<String, String> paramList, DiscountSystemDAO.SystemType type, DialogMode dialogMode) {
        super(Display.getCurrent().getActiveShell(), dialogMode, paramList);
        this.parentGroup = parentGroup;
        this.discountCampaign = discountCampaign;
        this.type = type;
        this.isBonusEarnSystem = type == DiscountSystemDAO.SystemType.EARN_BONUS_SYSTEM || type == DiscountSystemDAO.SystemType.PERIODIC_IMPACTS_BONUS_SYSTEM;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.fillTitleHeader((Named)this.parentGroup, (Named)this.discountCampaign);
        return content;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.childPanels = new ArrayList();
        TabFolder tabFolder = new TabFolder(container, 0);
        GridDataFactory defualtDataFactory = GridDataFactory.fillDefaults().align(4, 4).grab(true, true);
        defualtDataFactory.applyTo((Control)tabFolder);
        TabItem basicItem = new TabItem(tabFolder, 0);
        basicItem.setText("\u0411\u0430\u0437\u043e\u0432\u0430\u044f");
        this.basicPanel = new DiscountCampaignPanel((Composite)tabFolder, 0, DiscountCampaign.class, this.discountCampaign, this.type);
        this.basicPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        DiscountCampaign initedModel = (DiscountCampaign)this.basicPanel.getModel();
        if (this.getDialogMode() == DialogMode.CREATE) {
            this.basicPanel.initDefault((Object)initedModel);
        }
        this.basicPanel.initialize();
        basicItem.setControl(this.basicPanel);
        this.childPanels.add(this.basicPanel);
        if (this.isBonusEarnSystem || this.isShowTimeLiveForDiscSystem && this.type == DiscountSystemDAO.SystemType.DISCOUNT_SYSTEM) {
            TabItem bonusesItem = new TabItem(tabFolder, 0);
            bonusesItem.setText(this.isBonusEarnSystem ? "\u0411\u043e\u043d\u0443\u0441\u044b" : "\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438");
            this.bonusesPanel = new DiscountCampaignBonusesPanel((Composite)tabFolder, 0, DiscountCampaign.class, this.discountCampaign, this.isBonusEarnSystem, this.getDialogMode());
            this.bonusesPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.bonusesPanel.initialize();
            bonusesItem.setControl(this.bonusesPanel);
            this.childPanels.add(this.bonusesPanel);
        }
        if (LibActivator.getDefault().getDictionaryVersion() > 10) {
            TabItem tagsItem = new TabItem(tabFolder, 0);
            tagsItem.setText("\u041c\u0435\u0442\u043a\u0438");
            this.tagsPanel = new DiscountCampaignTagsPanel((Composite)tabFolder, 0, DiscountCampaign.class, this.discountCampaign, this.isBonusEarnSystem);
            this.tagsPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.tagsPanel.initialize();
            tagsItem.setControl(this.tagsPanel);
            this.childPanels.add(this.tagsPanel);
        }
        return container;
    }

    @Override
    public void applyRights(String selector) {
        for (EditorComposite<?> panel : this.childPanels) {
            if (panel == null) continue;
            panel.applyRights(selector);
        }
        super.applyRights(selector);
    }

    protected void okPressed() {
        DiscountCampaign model = (DiscountCampaign)this.basicPanel.getModel();
        if (model == null || model.getName() == null || model.getName().isEmpty()) {
            ErrorMessageFactory.emptyFieldMessage();
        } else if (model.getBeginDate() != null && model.getEndDate() != null && model.getBeginDate().after(model.getEndDate())) {
            ErrorMessageFactory.generalErrorMessage("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f. \u0410\u043a\u0446\u0438\u044f \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c!");
        } else if (this.discountCampaign.getId() != null && !this.discountCampaign.getId().equals(model.getId()) && AutoincCodes.checkCodesDiscountCampaign((DiscountCampaignGroup)this.parentGroup, (Long)model.getId())) {
            ErrorMessageFactory.retryCodeMessage();
        } else {
            FieldsUtils.copyOnlyAnnotatedProperties(model, this.discountCampaign, this.basicPanel.getClass());
            if (this.bonusesPanel != null) {
                model = (DiscountCampaign)this.bonusesPanel.getModel();
                FieldsUtils.copyOnlyAnnotatedProperties(model, this.discountCampaign, this.bonusesPanel.getClass());
                if (((MyKeyValue)Directory.bonusesIntervalConditionType.get(0)).getKey().equals(model.getBeginBonusesIntervalCondition()) && ((MyKeyValue)Directory.bonusesIntervalConditionType.get(1)).getKey().equals(model.getEndBonusesIntervalCondition())) {
                    ErrorMessageFactory.generalErrorMessage("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c\n       '\u041d\u0430\u0447\u0430\u043b\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f' \u0432 '\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e' \u0438 \n       '\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f' \u0432 '\u0447\u0435\u0440\u0435\u0437',\n\u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u043c\u0435\u0441\u0442\u043e \u044d\u0442\u043e\u0433\u043e \u0432\n       '\u041d\u0430\u0447\u0430\u043b\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f' \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0439\u0442\u0435 '\u0447\u0435\u0440\u0435\u0437 0 \u0434\u043d\u0435\u0439'");
                    return;
                }
                this.discountCampaign.setBeginBonusesIntervalCondition(model.getBeginBonusesIntervalCondition());
                this.discountCampaign.setEndBonusesIntervalCondition(model.getEndBonusesIntervalCondition());
                this.discountCampaign.setEndRangeDate(DateUtils.addDays((Date)this.discountCampaign.getEndRangeDate(), (int)1));
            }
            if (this.tagsPanel != null) {
                this.discountCampaign.setCheckedTags(((DiscountCampaignTagsPanel)this.tagsPanel).getGroupingTags());
                this.discountCampaign.setTagsIsAllowed(((DiscountCampaign)this.tagsPanel.getModel()).isTagsIsAllowed());
            }
            super.okPressed();
        }
    }
}

