/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import com.rits.cloning.Cloner;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.dialogs.SystemTitleAreaDialog;
import su.artix.discountmanager.dialogs.discountsystem.CounterPanel;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.loyaltylib.domain.java.discountsystem.Counter;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateCalculate;
import su.artix.yuki.editors.DialogMode;

@SecurityKey(title="\u0421\u0447\u0435\u0442\u0447\u0438\u043a\u0438")
public class CounterDialog
extends SystemTitleAreaDialog {
    private Discount discount;
    private Counter counter;
    private CounterPanel counterPanel;

    public CounterDialog(Discount discount, Counter counter, DiscountSystemDAO.SystemType type, DialogMode dialogMode) {
        super(Display.getCurrent().getActiveShell(), dialogMode, null);
        this.discount = discount;
        this.counter = counter;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.setTitleDialog(String.valueOf(this.getDialogMode() == DialogMode.CREATE ? "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435" : "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435") + " \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430");
        this.setMessage("\u0421\u0447\u0435\u0442\u0447\u0438\u043a");
        return content;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.counterPanel = new CounterPanel(container, 0, Counter.class, this.counter);
        this.counterPanel.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        if (this.getDialogMode() == DialogMode.CREATE) {
            Counter initedModel = (Counter)this.counterPanel.getModel();
            this.counterPanel.initDefault(initedModel);
        }
        this.counterPanel.initialize();
        return container;
    }

    @Override
    public void applyRights(String selector) {
        this.counterPanel.applyRights();
        super.applyRights(selector);
    }

    protected void okPressed() {
        Counter model = (Counter)this.counterPanel.getModel();
        if (model == null || model.getCounterId() == null || model.getRate() == null) {
            ErrorMessageFactory.emptyFieldMessage();
        } else {
            DiscountRate rate;
            if ((this.getDialogMode() == DialogMode.CREATE || !((Counter)this.counterPanel.getModel()).getCounterId().equals(this.counter.getCounterId())) && CollectionUtils.isNotEmpty((Collection)this.discount.getCounters())) {
                for (Counter g : this.discount.getCounters()) {
                    if (!model.getCounterId().equals(g.getCounterId())) continue;
                    ErrorMessageFactory.generalErrorMessage("\u0421\u0447\u0435\u0442\u0447\u0438\u043a \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u0443\u0436\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d");
                    return;
                }
            }
            if ((rate = model.getRate()) == null) {
                rate = new DiscountRateCalculate(this.counterPanel.getDiscountRate(), "sum");
            } else {
                try {
                    Cloner cloner = new Cloner();
                    cloner.dontCloneInstanceOf(new Class[]{PropertyChangeSupport.class});
                    rate = (DiscountRate)cloner.deepClone((Object)rate);
                }
                catch (Exception exception) {}
            }
            rate.setDiscountValue((Object)this.counterPanel.getDiscountRate());
            model.setRate(rate);
            super.okPressed();
        }
    }

    public Counter getCounter() {
        return (Counter)this.counterPanel.getModel();
    }
}

