/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.audit.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.audit.compare.CompareAuditItem;

public class CompareAuditInput
extends CompareEditorInput {
    private static final Logger log = LoggerFactory.getLogger(CompareAuditInput.class);
    private static final String NULL_STR = "null";
    private final Object data;
    private final Map<String, String> labels;

    public CompareAuditInput(Object data, CompareConfiguration configuration, Map<String, String> labels) {
        super(configuration);
        this.data = data;
        this.labels = labels;
    }

    protected Object prepareInput(IProgressMonitor pm) {
        try {
            CompareAuditItem left = new CompareAuditItem("Left", this.getData("OLD"));
            CompareAuditItem right = new CompareAuditItem("Right", this.getData("NEW"));
            return new DiffNode((ITypedElement)left, (ITypedElement)right);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getData(String suffix) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.labels.entrySet()) {
            builder.append(String.valueOf(entry.getValue()) + ": " + this.getValueFromCompareObject(suffix, entry) + "\n");
        }
        return builder.toString();
    }

    private String getValueFromCompareObject(String suffix, Map.Entry<String, String> entry) {
        try {
            return "" + PropertyUtils.getProperty((Object)this.data, (String)(String.valueOf(entry.getKey()) + suffix));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return NULL_STR;
        }
    }
}

