/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.cashtree.model.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import su.artix.cashserver.cashtree.domain.Category;
import su.artix.cashserver.cashtree.domain.Group;
import su.artix.cashserver.cashtree.domain.MiddleServer;
import su.artix.cashserver.cashtree.domain.Node;
import su.artix.cashserver.cashtree.domain.Shop;
import su.artix.cashserver.cashtree.domain.converter.DomainConverter;
import su.artix.cashserver.cashtree.model.AbstractTreeModel;
import su.artix.cashserver.core.cashregistry.domain.CashServerMode;
import su.artix.cashserver.rest.client.IClientGetter;
import su.artix.cashserver.rest.domain.CashServerModeInfo;
import su.artix.cashserver.rest.domain.CategoryInfo;
import su.artix.cashserver.rest.domain.GroupInfo;
import su.artix.cashserver.rest.domain.MiddleServerInfo;
import su.artix.cashserver.rest.domain.ShopInfo;

public class TreeModelRest
extends AbstractTreeModel {
    private static final Logger log = LoggerFactory.getLogger(TreeModelRest.class);
    private static final String GROUP_CATEGORIES_ID = "DEFAULT_GROUP_CATEGORIES";
    @Autowired
    private IClientGetter clientGetter;
    @Autowired
    private DomainConverter domainConverter;

    public List<Node> getRoots(String clusterId) {
        ArrayList<Node> roots = new ArrayList<Node>();
        try {
            CashServerModeInfo serverMode = this.clientGetter.getClient().getSystemEntity().getCashServerModeInfo();
            if (CashServerMode.HierarchyMode.MIDDLE.equals((Object)serverMode.getHierarhyMode())) {
                MiddleServerInfo info = this.clientGetter.getClient().getMiddleServerEntity().getMiddleServer(serverMode.getCashserverId());
                MiddleServer middleServer = (MiddleServer)this.domainConverter.convert((Object)info, MiddleServer.class);
                if (middleServer.getShops() == null) {
                    ArrayList<String> shopIds = new ArrayList<String>();
                    List shops = this.clientGetter.getClient().getShopsEntity().getShopsByGroupCode(info.getId());
                    for (ShopInfo shop : shops) {
                        shopIds.add(shop.getId());
                    }
                    middleServer.setShops(shopIds);
                }
                roots.add((Node)middleServer);
            } else {
                roots.addAll(this.getRootGroups(clusterId));
                roots.addAll(this.getRootShops(clusterId));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return roots;
    }

    public List<Group> getRootGroups(String clusterId) {
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            groups.addAll(this.getGroupCategories(clusterId));
            for (GroupInfo info : this.clientGetter.getClient().getGroupEntity().getRootGroups()) {
                if (!StringUtils.isEmpty((String)clusterId) && !StringUtils.isEmpty((String)info.getClusterId()) && !clusterId.equals(info.getClusterId())) continue;
                Group group = (Group)this.domainConverter.convert((Object)info, Group.class);
                if (group.getMiddleServers() == null) {
                    ArrayList<String> middleServerIds = new ArrayList<String>();
                    List middleServers = this.clientGetter.getClient().getMiddleServerEntity().getMiddleServersByGroupId(group.getId());
                    for (MiddleServerInfo middleServer : middleServers) {
                        middleServerIds.add(middleServer.getId());
                    }
                    group.setMiddleServers(middleServerIds);
                }
                groups.add(group);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public List<Shop> getRootShops(String clusterId) {
        ArrayList<Shop> shops = new ArrayList<Shop>();
        try {
            for (ShopInfo info : this.clientGetter.getClient().getShopsEntity().getShopInfosList()) {
                if (info.getParentObject() != null || !StringUtils.isEmpty((String)clusterId) && !clusterId.equals(info.getClusterId())) continue;
                shops.add((Shop)this.domainConverter.convert((Object)info, Shop.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return shops;
    }

    public List<Group> getGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            for (GroupInfo info : this.clientGetter.getClient().getGroupEntity().getGroups()) {
                groups.add((Group)this.domainConverter.convert((Object)info, Group.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public List<MiddleServer> getMiddleServers() {
        ArrayList<MiddleServer> middleServers = new ArrayList<MiddleServer>();
        try {
            for (MiddleServerInfo info : this.clientGetter.getClient().getMiddleServerEntity().getMiddleServers()) {
                middleServers.add((MiddleServer)this.domainConverter.convert((Object)info, MiddleServer.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return middleServers;
    }

    public List<Shop> getShops() {
        ArrayList<Shop> shops = new ArrayList<Shop>();
        try {
            for (ShopInfo info : this.clientGetter.getClient().getShopsEntity().getShopInfosList()) {
                shops.add((Shop)this.domainConverter.convert((Object)info, Shop.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return shops;
    }

    public List<Group> getGroupsByParentCode(String clusterId, String code) {
        if (StringUtils.isEmpty((String)code)) {
            return Collections.emptyList();
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            for (GroupInfo info : this.clientGetter.getClient().getGroupEntity().getGroupsByGroupCode(code)) {
                if (!StringUtils.isEmpty((String)clusterId) && !clusterId.equals(info.getClusterId())) continue;
                Group group = (Group)this.domainConverter.convert((Object)info, Group.class);
                if (group.getMiddleServers() == null) {
                    ArrayList<String> middleServerIds = new ArrayList<String>();
                    List middleServers = this.clientGetter.getClient().getMiddleServerEntity().getMiddleServersByGroupId(group.getId());
                    for (MiddleServerInfo middleServer : middleServers) {
                        middleServerIds.add(middleServer.getId());
                    }
                    group.setMiddleServers(middleServerIds);
                }
                groups.add(group);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public List<MiddleServer> getMiddleServersByParentCode(String clusterId, String code) {
        if (StringUtils.isEmpty((String)code)) {
            return Collections.emptyList();
        }
        ArrayList<MiddleServer> middleServers = new ArrayList<MiddleServer>();
        try {
            for (MiddleServerInfo info : this.clientGetter.getClient().getMiddleServerEntity().getMiddleServersByGroupId(code)) {
                if (!StringUtils.isEmpty((String)clusterId) && !clusterId.equals(info.getClusterId())) continue;
                MiddleServer middleServer = (MiddleServer)this.domainConverter.convert((Object)info, MiddleServer.class);
                if (middleServer.getShops() == null) {
                    ArrayList<String> shopIds = new ArrayList<String>();
                    List shops = this.clientGetter.getClient().getShopsEntity().getShopsByGroupCode(info.getId());
                    for (ShopInfo shop : shops) {
                        shopIds.add(shop.getId());
                    }
                    middleServer.setShops(shopIds);
                }
                middleServers.add(middleServer);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return middleServers;
    }

    public List<Shop> getShopsByParentCode(String clusterId, String code) {
        if (StringUtils.isEmpty((String)code)) {
            return Collections.emptyList();
        }
        ArrayList<Shop> shops = new ArrayList<Shop>();
        try {
            for (ShopInfo info : this.clientGetter.getClient().getShopsEntity().getShopsByGroupCode(code)) {
                if (!StringUtils.isEmpty((String)clusterId) && !clusterId.equals(info.getClusterId())) continue;
                shops.add((Shop)this.domainConverter.convert((Object)info, Shop.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return shops;
    }

    private List<Group> getGroupCategories(String clusterId) {
        ArrayList<Group> groups = new ArrayList<Group>();
        Group fakeGroup = new Group();
        fakeGroup.setClusterId(clusterId);
        fakeGroup.setId(GROUP_CATEGORIES_ID);
        fakeGroup.setTitle("\u0412\u0441\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
        fakeGroup.setCategories(new ArrayList());
        try {
            for (CategoryInfo info : this.clientGetter.getClient().getCategoryEntity().getCategories()) {
                if (!StringUtils.isEmpty((String)clusterId) && !StringUtils.isEmpty((String)info.getClusterId()) && !clusterId.equals(info.getClusterId())) continue;
                fakeGroup.getCategories().add(info.getId());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (!fakeGroup.getCategories().isEmpty()) {
            groups.add(fakeGroup);
        }
        return groups;
    }

    public List<Category> getCategoriesByParentCode(String clusterId, String code) {
        if (!GROUP_CATEGORIES_ID.equals(code)) {
            return Collections.emptyList();
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        try {
            for (CategoryInfo info : this.clientGetter.getClient().getCategoryEntity().getCategories()) {
                if (!StringUtils.isEmpty((String)clusterId) && !StringUtils.isEmpty((String)info.getClusterId()) && !clusterId.equals(info.getClusterId())) continue;
                categories.add((Category)this.domainConverter.convert((Object)info, Category.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return categories;
    }
}

