/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.cashtree.model.rest;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import su.artix.cashserver.cashtree.domain.Tag;
import su.artix.cashserver.cashtree.domain.TagType;
import su.artix.cashserver.cashtree.domain.converter.DomainConverter;
import su.artix.cashserver.cashtree.model.AbstractTagModel;
import su.artix.cashserver.core.cashregistry.domain.ShopGroupLabel;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.cashserver.rest.client.IClientGetter;

public class TagModelRest
extends AbstractTagModel {
    private static final Logger log = LoggerFactory.getLogger(TagModelRest.class);
    @Autowired
    private IClientGetter clientGetter;
    @Autowired
    private DomainConverter domainConverter;

    public List<TagType> getTagTypes() {
        ArrayList<TagType> tagTypes = new ArrayList<TagType>();
        try {
            for (ShopGroupLabel groupLabel : this.clientGetter.getClient().getShopGroupLabelEntity().getShopGroupLabels()) {
                tagTypes.add((TagType)this.domainConverter.convert((Object)groupLabel, TagType.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tagTypes;
    }

    public List<Tag> getTagsByType(TagType type) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            for (ShopLabel label : this.clientGetter.getClient().getShopLabelEntity().getShopLabels(type.getId())) {
                tags.add((Tag)this.domainConverter.convert((Object)label, Tag.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tags;
    }

    public List<Tag> getTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            for (ShopLabel label : this.clientGetter.getClient().getShopLabelEntity().getShopLabels()) {
                tags.add((Tag)this.domainConverter.convert((Object)label, Tag.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tags;
    }

    public void addTagType(TagType tagType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void editTagType(TagType oldTagType, TagType newTagType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void delTagType(TagType tagType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void addTag(Tag tag) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void editTag(Tag oldTag, Tag newTag) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void delTag(Tag tag) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isExistTagType(String type) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isExistTag(Tag tag) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

