/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.domain.java.discountsystem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitObjectItem;
import su.artix.loyaltylib.domain.java.observable.DiscountTreeTypeAction;

public class DiscountRateKitObject
extends DiscountRate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<DiscountRateKitObjectItem> kitItems = new ArrayList<DiscountRateKitObjectItem>();

    public List<DiscountRateKitObjectItem> getKitItems() {
        return this.kitItems;
    }

    public void setKitItems(List<DiscountRateKitObjectItem> kitItems) {
        if (!ObjectUtils.equals(this.kitItems, kitItems)) {
            this.kitItems = kitItems;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    @Override
    public String getNameTreeNode() {
        ArrayList<String> items = new ArrayList<String>(this.kitItems.size());
        for (DiscountRateKitObjectItem item : this.kitItems) {
            if (item.getDiscountKitObjectItem() != null && item.getDiscountRate() != null) {
                items.add(String.format("\u041d\u0430 %s %s", item.getDiscountKitObjectItem().getName(), item.getDiscountRate().getNameTreeNode()));
                continue;
            }
            items.add("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430");
        }
        return new StringBuffer().append("[").append(StringUtils.join(items, (String)"], [")).append("]").toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DiscountRateKitObject [kitItems=");
        builder.append(this.kitItems);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Object getDiscountValue() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kitItems == null ? 0 : this.kitItems.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscountRateKitObject other = (DiscountRateKitObject)obj;
        return !(this.kitItems == null ? other.kitItems != null : !this.kitItems.equals(other.kitItems));
    }
}

