/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.domain.java.discountsystem;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountConditionTemplate;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.loyaltylib.domain.java.observable.DiscountTreeTypeAction;

public class DiscountCondition
extends AbstractDiscountModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String condition;
    private String description;
    private DiscountConditionTemplate template;
    private Discount parent;

    public DiscountCondition() {
        this.condition = "";
        this.description = "";
    }

    public DiscountCondition(String condition, String description) {
        this.condition = condition;
        this.description = description;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        if (!StringUtils.equals((CharSequence)this.condition, (CharSequence)condition)) {
            this.condition = condition;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (!StringUtils.equals((CharSequence)this.description, (CharSequence)description)) {
            this.description = description;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public DiscountConditionTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(DiscountConditionTemplate template) {
        this.template = template;
    }

    public void setParent(Discount parent) {
        this.parent = parent;
    }

    @Override
    public Discount getParent() {
        return this.parent;
    }

    @Override
    public String getNameTreeNode() {
        if (this.description.isEmpty()) {
            return "() [" + this.condition + "]";
        }
        return "(" + this.description + ")";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DiscountCondition [condition=");
        builder.append(this.condition);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equalsWithoutParent(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscountCondition other = (DiscountCondition)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    public boolean equals(Object obj) {
        if (this.equalsWithoutParent(obj)) {
            return !(this.parent == null ? ((DiscountCondition)obj).parent != null : !this.parent.equals(((DiscountCondition)obj).parent));
        }
        return false;
    }
}

