/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.systemMonitor;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.mihalis.opal.systemMonitor.Sample;

public class CPUUsageSample
implements Sample {
    private static final String PROCESS_CPU_TIME = "ProcessCpuTime";
    private static final String OBJECT_NAME_ATTRIBUTE = "java.lang:type=OperatingSystem";
    private final MBeanServerConnection mBeanServerConnection = ManagementFactory.getPlatformMBeanServer();
    private ObjectName objectName;
    private long time;
    private long processTime;

    public CPUUsageSample() {
        try {
            this.objectName = new ObjectName(OBJECT_NAME_ATTRIBUTE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double getValue() {
        try {
            float f = (Long)this.mBeanServerConnection.getAttribute(this.objectName, PROCESS_CPU_TIME) - this.processTime;
            this.time = System.nanoTime();
            this.processTime = (Long)this.mBeanServerConnection.getAttribute(this.objectName, PROCESS_CPU_TIME);
            return f /= (float)(System.nanoTime() - this.time);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }
}

