/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow.widgets;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.preferenceWindow.widgets.PWChooser;
import org.mihalis.opal.utils.ResourceManager;

public class PWFontChooser
extends PWChooser {
    private FontData fontData;

    public PWFontChooser(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void check() {
        Object object = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (object == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), null);
        } else if (!(object instanceof FontData)) {
            throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a FontData because it is associated to a font chooser");
        }
    }

    @Override
    protected void setButtonAction(final Text text, Button button) {
        this.fontData = (FontData)PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FontDialog fontDialog = new FontDialog(text.getShell());
                FontData fontData = fontDialog.open();
                if (fontData != null && fontData.getName() != null && !"".equals(fontData.getName().trim())) {
                    PWFontChooser.this.fontData = fontData;
                    PreferenceWindow.getInstance().setValue(PWFontChooser.this.getPropertyKey(), fontData);
                    text.setText(PWFontChooser.this.buildFontInformation());
                }
            }
        });
    }

    protected String buildFontInformation() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fontData != null) {
            stringBuilder.append(this.fontData.getName()).append(",").append(this.fontData.getHeight()).append(" pt");
            if ((this.fontData.getStyle() & 1) == 1) {
                stringBuilder.append(", ").append(ResourceManager.getLabel("bold"));
            }
            if ((this.fontData.getStyle() & 2) == 2) {
                stringBuilder.append(", ").append(ResourceManager.getLabel("italic"));
            }
        }
        return stringBuilder.toString();
    }
}

