/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.obutton;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.obutton.ButtonRenderer;
import org.mihalis.opal.obutton.DefaultButtonRenderer;

public class OButton
extends Canvas {
    private static final String IS_BUTTON_PRESSED = OButton.class.toString() + "_pressed";
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    int alignment = 16384;
    private ButtonRenderer buttonRenderer = DefaultButtonRenderer.getInstance();
    boolean selected;
    boolean hover;
    String text;
    Image image;
    private int width = -1;
    private int height = -1;
    private boolean clicked;

    public OButton(Composite composite, int n) {
        super(composite, OButton.checkStyle(n) | 0x20000000);
        this.addListeners();
    }

    private static int checkStyle(int n) {
        if (((n = OButton.checkBits(n, 8, 4, 2, 0)) & 0xA) != 0) {
            return OButton.checkBits(n, 0x1000000, 16384, 131072, 0);
        }
        if ((n & 4) != 0) {
            return OButton.checkBits(n, 128, 1024, 16384, 131072);
        }
        return n;
    }

    private static int checkBits(int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 | n3 | n4 | n5;
        if ((n & n6) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n6 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n6 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n6 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n6 | n5;
        }
        return n;
    }

    private void addListeners() {
        int[] nArray;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 6: {
                        OButton.this.hover = true;
                        OButton.this.redraw();
                        OButton.this.update();
                        break;
                    }
                    case 7: {
                        OButton.this.hover = false;
                        OButton.this.redraw();
                        OButton.this.update();
                        break;
                    }
                    case 3: {
                        OButton.this.clicked = true;
                        OButton.this.setData(IS_BUTTON_PRESSED, "*");
                        OButton.this.redraw();
                        OButton.this.update();
                        break;
                    }
                    case 4: {
                        if (OButton.this.getData(IS_BUTTON_PRESSED) == null) {
                            return;
                        }
                        OButton.this.setData(IS_BUTTON_PRESSED, null);
                        OButton.this.clicked = false;
                        OButton.this.selected = !OButton.this.selected;
                        OButton.this.redraw();
                        OButton.this.update();
                        OButton.this.fireSelectionEvent();
                        break;
                    }
                    case 9: {
                        OButton.this.handlePaintEvent(event);
                        break;
                    }
                    case 1: {
                        if (event.keyCode != 9) break;
                        if (event.stateMask == 131072) {
                            OButton.this.traverse(8);
                            break;
                        }
                        OButton.this.traverse(16);
                        break;
                    }
                    case 12: {
                        OButton.this.buttonRenderer.dispose();
                    }
                }
            }
        };
        for (int n : nArray = new int[]{6, 7, 3, 4, 9, 12}) {
            this.addListener(n, listener);
        }
    }

    protected void fireSelectionEvent() {
        Event event = new Event();
        event.widget = this;
        event.display = this.getDisplay();
        event.type = 13;
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    private void handlePaintEvent(Event event) {
        boolean bl;
        if (!this.isEnabled()) {
            this.buttonRenderer.drawButtonWhenDisabled(event.gc, this);
            return;
        }
        if (this.clicked) {
            this.buttonRenderer.drawButtonWhenClicked(event.gc, this);
            return;
        }
        if (this.hover) {
            this.buttonRenderer.drawButtonWhenMouseHover(event.gc, this);
            return;
        }
        boolean bl2 = bl = (this.getStyle() & 2) == 2;
        if (bl && this.selected) {
            this.buttonRenderer.drawButtonWhenSelected(event.gc, this);
            return;
        }
        this.buttonRenderer.drawButton(event.gc, this);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(selectionListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = this.buttonRenderer.computeSize(this, n, n2, bl);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        this.setWidth(point.x);
        this.setHeight(point.y);
        return point;
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public ButtonRenderer getButtonRenderer() {
        this.checkWidget();
        return this.buttonRenderer;
    }

    public int getHeight() {
        this.checkWidget();
        if (this.height == -1) {
            return this.computeSize((int)-1, (int)-1, (boolean)false).y;
        }
        return this.height;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selected;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public int getWidth() {
        this.checkWidget();
        if (this.width == -1) {
            return this.computeSize((int)-1, (int)-1, (boolean)false).x;
        }
        return this.width;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if (n != 16384 && n != 131072 && n != 0x1000000) {
            SWT.error((int)5);
        }
        this.alignment = n;
        this.redraw();
        this.update();
    }

    public void setButtonRenderer(ButtonRenderer buttonRenderer) {
        this.buttonRenderer = buttonRenderer;
    }

    public void setHeight(int n) {
        this.checkWidget();
        this.height = Math.max(n, 0);
        this.redraw();
        this.update();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error((int)5);
        }
        this.image = image;
        this.buttonRenderer.createDisabledImage();
        this.redraw();
        this.update();
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        this.selected = bl;
        this.redraw();
        this.update();
    }

    public void setText(String string) {
        this.checkWidget();
        this.text = string;
        this.redraw();
        this.update();
    }

    public void setWidth(int n) {
        this.checkWidget();
        this.width = Math.max(0, n);
        this.redraw();
        this.update();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.redraw();
        this.update();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.redraw();
        this.update();
    }

    public void setSize(Point point) {
        super.setSize(point);
        this.redraw();
        this.update();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.redraw();
        this.update();
    }
}

