/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.discount.condition.constructor.dao.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import su.artix.yuki.discount.condition.constructor.dao.TreeException;
import su.artix.yuki.discount.condition.constructor.dao.impl.ConstructorTreeDAO;
import su.artix.yuki.discount.condition.constructor.dao.impl.FillParentAndFullnameListener;
import su.artix.yuki.discount.condition.domain.xml.TreeRootNode;

public class ConstructorTreeFileDAO
implements ConstructorTreeDAO {
    private Unmarshaller unmarshaller;
    private List<String> xmlFiles;
    private String filePath;

    public ConstructorTreeFileDAO(String filePath) throws TreeException {
        this.filePath = filePath;
        this.initUnmarshaller();
    }

    public ConstructorTreeFileDAO(String xmlFile, String packageXmlFile) throws TreeException {
        this(Arrays.asList(xmlFile, packageXmlFile));
    }

    public ConstructorTreeFileDAO(List<String> xmlFiles) throws TreeException {
        if (xmlFiles == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 xmlFiles \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Iterator<String> iter = xmlFiles.iterator();
        while (iter.hasNext()) {
            String str = iter.next();
            if (str != null) continue;
            iter.remove();
        }
        this.xmlFiles = xmlFiles;
        this.initUnmarshaller();
    }

    private void initUnmarshaller() throws TreeException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TreeRootNode.class});
            this.unmarshaller = context.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new TreeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0434\u0435\u043c\u0430\u0440\u0448\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430: " + e.getMessage(), e);
        }
        this.unmarshaller.setListener((Unmarshaller.Listener)new FillParentAndFullnameListener());
    }

    @Override
    public TreeRootNode getTree() throws TreeException {
        InputStream in = null;
        if (this.filePath != null && !this.filePath.isEmpty()) {
            try {
                in = new FileInputStream(new File(this.filePath));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String variant : this.xmlFiles) {
                in = classLoader.getResourceAsStream(variant);
                if (in != null) break;
            }
        }
        if (in == null) {
            throw new TreeException("\u0424\u0430\u0439\u043b \u0441 xml \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0418\u0441\u043a\u0430\u043b\u0438\u0441\u044c \u0444\u0430\u0439\u043b\u044b: " + this.filePath + " \u0438\u043b\u0438 " + this.xmlFiles);
        }
        TreeRootNode root = this.getTree(in);
        try {
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return root;
    }

    public TreeRootNode getTree(InputStream stream) throws TreeException {
        if (stream == null) {
            throw new IllegalArgumentException("\u0412\u0445\u043e\u0434\u043d\u043e\u0439 \u043f\u043e\u0442\u043e\u043a \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null. \u0424\u0430\u0439\u043b\u044b: " + this.xmlFiles);
        }
        TreeRootNode root = null;
        try {
            Object obj = this.unmarshaller.unmarshal(stream);
            if (obj == null) {
                throw new TreeException("\u0414\u0435\u043c\u0430\u0440\u0448\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440 \u0432\u0435\u0440\u043d\u0443\u043b null");
            }
            root = (TreeRootNode)obj;
        }
        catch (JAXBException e) {
            throw new TreeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u043c\u0430\u0440\u0448\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430: " + e.getMessage(), e);
        }
        return root;
    }

    public void addXmlFile(String fileName) {
        this.xmlFiles.add(fileName);
    }

    public void clearXmlFilePaths() {
        this.xmlFiles.clear();
    }

    public void setUnmarshallerListener(Unmarshaller.Listener listener) {
        this.unmarshaller.setListener(listener);
    }
}

