/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.discount;

import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.view.directory.discount.AddCardCertificateDialog;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Card;
import ru.ssa.cashadmin.domain.Certificate;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.utils.InfoMessageFactory;
import su.artix.discountmanager.utils.MultiLineDialogOperations;
import su.artix.discountmanager.utils.MultiLineMessages;
import su.artix.discountmanagercore.model.accounting.AccountingResult;
import su.artix.yuki.action.SecurityActionImpl;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.directory.DirectoryEditModel;
import su.artix.yuki.model.directory.DirectoryModelFactory;

public class CreateCertificateAction
extends SecurityActionImpl<Certificate> {
    private static final Logger log = LoggerFactory.getLogger(CreateCertificateAction.class);

    public CreateCertificateAction() {
        super(Certificate.class, false);
        ArtixAdminImages images = ArtixAdminImages.getDefault();
        this.setImageDescriptor(images.getImageDescriptor("plane/16x16/action"));
    }

    public String getToolTipText() {
        return "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u044b";
    }

    public String getText() {
        return "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u044b";
    }

    public void run() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof StructuredSelection) {
            final Certificate certificate = (Certificate)((StructuredSelection)selection).getFirstElement();
            AddCardCertificateDialog dlg = new AddCardCertificateDialog(Display.getCurrent().getActiveShell(), certificate);
            if (dlg.open() == 0) {
                Activator.getDefault().setLoadCursor(true);
                final AtomicBoolean abortCommand = new AtomicBoolean(false);
                MultiLineDialogOperations cardMessageOperations = new MultiLineDialogOperations(){

                    public void abortOperation() {
                        abortCommand.set(true);
                    }
                };
                final MultiLineMessages messages = InfoMessageFactory.multiLineInfoMessage((MultiLineDialogOperations)cardMessageOperations);
                ArtixAdminContextHolder.getConnectionId();
                final String connectionId = ArtixAdminContextHolder.getConnectionId();
                Thread changeCardsThread = new Thread("CardChangedThread"){

                    @Override
                    public void run() {
                        ArtixAdminContextHolder.setConnectionId((String)connectionId);
                        boolean errorExist = false;
                        DirectoryEditModel directoryModel = DirectoryModelFactory.getModel(Card.class);
                        int countDigts = certificate.getRangeto().length();
                        long i = Long.valueOf(certificate.getRangefrom());
                        while (i <= Long.valueOf(certificate.getRangeto())) {
                            Card card = (Card)LibActivator.getDefault().getActualClassResolver().getInstance(Card.class);
                            String number = StringUtils.leftPad((String)String.valueOf(i), (int)countDigts, (String)"0");
                            card.setNumber(number);
                            try {
                                if (abortCommand.get()) break;
                                if (directoryModel.getList((Object)card).isEmpty()) {
                                    directoryModel.save((Object)card);
                                    messages.addMessage("\u041a\u0430\u0440\u0442\u0430 \u2116: " + card.getNumber() + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
                                } else {
                                    errorExist = true;
                                    messages.addMessage("\u041a\u0430\u0440\u0442\u0430 \u2116: " + card.getNumber() + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                                }
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                errorExist = true;
                                messages.addMessage("\u041a\u0430\u0440\u0442\u0430 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + card.getNumber() + " \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0430: {}" + e.getMessage());
                            }
                            ++i;
                        }
                        directoryModel.doRefresh();
                        messages.lastMessage(errorExist ? "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438" : "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0431\u0435\u0437 \u043e\u0448\u0438\u0431\u043e\u043a");
                    }
                };
                changeCardsThread.start();
                Activator.getDefault().setLoadCursor(false);
            }
        }
    }

    private String checkAccountingResult(AccountingResult accountingResult) {
        String mess = "";
        if (accountingResult == null) {
            mess = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0430\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u043e\u0442\u0432\u0435\u0442\u0438\u043b \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441.";
            log.warn("Operation didn't execute on accounting server, may be operation didn't support on your version of accounting server");
        } else if (!accountingResult.isSuccess()) {
            log.debug("{}", (Object)accountingResult);
            String errorMessage = null;
            if (accountingResult.getSessionId() == null) {
                errorMessage = accountingResult.getDescription();
            } else {
                BigDecimal balance = new BigDecimal(accountingResult.getBalance());
                balance = balance.movePointLeft(2);
                errorMessage = "ID \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438: " + accountingResult.getSessionId() + "; \u0411\u0430\u043b\u0430\u043d\u0441: " + balance + "; \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: " + accountingResult.getDescription();
            }
            mess = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0443\u0434\u0430\u043b\u0430\u0441\u044c." + errorMessage;
        }
        return mess;
    }
}

