/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.action;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.HotKeyInvent;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

class UpActionHotKey
extends Action {
    private static final Logger log = LoggerFactory.getLogger(UpActionHotKey.class);
    private HotKeyInvent model;
    private TableViewer tableViewer;

    private UpActionHotKey() {
        super("\u0423\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c \u043f\u043e\u0440\u044f\u0434\u043e\u043a");
        this.setToolTipText("\u0423\u043c\u0435\u043d\u044c\u0448\u0435\u043d\u0438\u0435 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430");
    }

    public UpActionHotKey(TableViewer tableViewer, ImageDescriptor imageDescriptor) {
        this();
        this.tableViewer = tableViewer;
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        try {
            DirectoryEditModel directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(HotKeyInvent.class);
            this.model = (HotKeyInvent)((StructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            if (this.model != null && this.model.getHotkey() != null) {
                HotKeyInvent filter = (HotKeyInvent)LibActivator.getDefault().getActualClassResolver().getInstance(HotKeyInvent.class);
                filter.setHotkey(this.model.getHotkey());
                List hotkeyInvents = directoryModel.getList((Object)filter);
                Collections.sort(hotkeyInvents, new Comparator<HotKeyInvent>(){

                    @Override
                    public int compare(HotKeyInvent o1, HotKeyInvent o2) {
                        return o1.getHotkeyinventid().compareTo(o2.getHotkeyinventid());
                    }
                });
                int upIndex = hotkeyInvents.indexOf(this.model);
                if (upIndex > 0) {
                    int order = this.model.getHotkeyinventid();
                    HotKeyInvent upModel = this.model;
                    while (order == this.model.getHotkeyinventid() && upIndex > 0) {
                        upModel = (HotKeyInvent)hotkeyInvents.get(--upIndex);
                        order = upModel.getHotkeyinventid();
                    }
                    upModel.setHotkeyinventid(this.model.getHotkeyinventid());
                    this.model.setHotkeyinventid(Integer.valueOf(order));
                    directoryModel.doUpdate((Object)this.model);
                    directoryModel.doUpdate((Object)upModel);
                    directoryModel.doRefresh();
                    this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.model));
                }
            }
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

