/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.provider.goods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventPrice;
import ru.ssa.cashadmin.domain.InventPriceV138;
import ru.ssa.cashadmin.domain.InventPriceV40;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.provider.IOrderedContentProvider;

public class TpricesContentProvider
implements IStructuredContentProvider,
IOrderedContentProvider {
    private Map<InventPrice, String> map = new LinkedHashMap<InventPrice, String>();
    private boolean ascending = true;
    private String sortBy;
    private final TableViewer tableViewer;

    public TpricesContentProvider(Invent model, TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.sortBy = "tindex";
        if (model.getBcode() != null) {
            InventPrice price = (InventPrice)LibActivator.getDefault().getActualClassResolver().getInstance(InventPrice.class);
            price.setBcode(model.getBcode());
            List objects = ModelActivator.getDefault().getModelProvider().getDirectoryModel(InventPrice.class).getList(this.sortBy, this.ascending, (Object)price);
            for (InventPrice tprices : objects) {
                this.map.put(tprices, DirectoryAction.NONE.toString());
            }
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<InventPrice> collection = new ArrayList<InventPrice>();
        for (InventPrice key : this.map.keySet()) {
            if (this.map.get(key).equals(DirectoryAction.REMOVE.toString())) continue;
            collection.add(key);
        }
        Collections.sort(collection, new Comparator<InventPrice>(){

            @Override
            public int compare(InventPrice o1, InventPrice o2) {
                int result = 0;
                if (TpricesContentProvider.this.sortBy.equals("tindex")) {
                    result = o1.getTindex().compareTo(o2.getTindex());
                    if (result == 0) {
                        if (o1 instanceof InventPriceV40) {
                            result = ((InventPriceV40)o1).getDocumentid().compareTo(((InventPriceV40)o2).getDocumentid());
                        } else if (o1 instanceof InventPriceV138) {
                            result = ((InventPriceV138)o1).getEffectivedate().compareTo(((InventPriceV138)o2).getEffectivedate());
                        }
                    }
                } else if (TpricesContentProvider.this.sortBy.equals("name")) {
                    result = o1.getName().compareTo(o2.getName());
                } else if (TpricesContentProvider.this.sortBy.equals("bcode")) {
                    result = o1.getPrice().compareTo(o2.getPrice());
                }
                return TpricesContentProvider.this.ascending ? result : result * -1;
            }
        });
        return collection.toArray();
    }

    public String getSortProperty() {
        return this.sortBy;
    }

    public void setSortProperty(String sortby) {
        this.sortBy = sortby;
        this.tableViewer.setInput(null);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public Map<InventPrice, String> getMap() {
        return this.map;
    }
}

