/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.goods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.utils.ArtixFilter;
import su.artix.widgets.FilterElement;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.model.directory.DirectoryEditModel;
import su.artix.yuki.model.directory.DirectoryModelFactory;
import su.artix.yuki.provider.IOrderedContentProvider;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableViewPanel;

public class MultiSelectCheckBoxTableViewer<JOITING, PRIMARY, SECONDARY> {
    private static Logger log = LoggerFactory.getLogger(MultiSelectCheckBoxTableViewer.class);
    private List<JOITING> joitings;
    private List<JOITING> joitingsBeginState;
    private Class<JOITING> joitingClazz;
    private Class<SECONDARY> secondaryClazz;
    private PRIMARY primary;
    private static Object secondaryEmptyInstance = null;
    private FilterElement secondaryFilterElement;
    private DialogMode dialogMode;

    public MultiSelectCheckBoxTableViewer(int style, DialogMode dialogMode, PRIMARY model, Class<JOITING> joitingClazz, Class<SECONDARY> secondaryClazz) {
        this.dialogMode = dialogMode;
        this.joitingClazz = joitingClazz;
        this.primary = model;
        this.secondaryClazz = secondaryClazz;
    }

    public SECONDARY getSecondaryFromJoiting(JOITING joiting) {
        return null;
    }

    public PRIMARY getPrimaryFromJoiting(JOITING joiting) {
        return null;
    }

    public JOITING setPrimary(JOITING joiting, PRIMARY primary) {
        return null;
    }

    public JOITING setSecondary(JOITING joiting, SECONDARY secondary) {
        return null;
    }

    protected void setFilterElement(FilterElement filterElement) {
        this.secondaryFilterElement = filterElement;
    }

    public DirectoryTableViewPanel<SECONDARY> getSecondaryPanel(Composite composite) {
        return new DirectoryTableViewPanel<SECONDARY>(composite, 2048, this.secondaryClazz, true){

            protected int getSelectionStyle() {
                return super.getSelectionStyle() | 0x20;
            }

            protected void createFilterMenu(Menu parent, Class<SECONDARY> clazz, TableViewer viewer) {
                this.setFilter(new ArtixFilter(clazz));
            }

            protected FilterElement getFilterElement() {
                MultiSelectCheckBoxTableViewer.this.secondaryFilterElement = super.getFilterElement();
                MultiSelectCheckBoxTableViewer.this.setFilterElement(MultiSelectCheckBoxTableViewer.this.secondaryFilterElement);
                return MultiSelectCheckBoxTableViewer.this.secondaryFilterElement;
            }
        };
    }

    public String getTextForTopLabel() {
        return "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b:";
    }

    public String getTextForSelectedCheckBox() {
        return "\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435";
    }

    public String getSortProperty() {
        return "code";
    }

    public SECONDARY createEmptySecondary(JOITING joiting) {
        if (secondaryEmptyInstance == null) {
            secondaryEmptyInstance = LibActivator.getDefault().getActualClassResolver().getInstance(this.secondaryClazz);
        }
        return (SECONDARY)secondaryEmptyInstance;
    }

    public boolean checkSecondaryOnEmpty(SECONDARY secondary) {
        return secondary == secondaryEmptyInstance;
    }

    public void createDeptValutListComposite(Composite parent) throws Exception {
        DirectoryEditModel directoryEditModelJoined = DirectoryModelFactory.getModel(this.joitingClazz);
        if (DialogMode.CREATE.equals((Object)this.dialogMode)) {
            this.joitings = new ArrayList<JOITING>();
        } else {
            Object joiting = LibActivator.getDefault().getActualClassResolver().getInstance(this.joitingClazz);
            joiting = this.setPrimary(joiting, this.primary);
            this.joitings = directoryEditModelJoined.getList(joiting);
        }
        if (DialogMode.COPY.equals((Object)this.dialogMode)) {
            this.joitingsBeginState = new ArrayList<JOITING>();
        } else {
            this.joitingsBeginState = new ArrayList<JOITING>(this.joitings.size());
            this.joitingsBeginState.addAll(this.joitings);
        }
        Label selectDeptsInfoLabel = new Label(parent, 0);
        selectDeptsInfoLabel.setText(this.getTextForTopLabel());
        final DirectoryTableViewPanel<SECONDARY> panel = this.getSecondaryPanel(parent);
        final LazyContentProvider lazyContentProvider = new LazyContentProvider<SECONDARY>(this.secondaryClazz, (TableViewer)panel.getViewer()){

            protected void customUpdate(TableItem item) {
                MultiSelectCheckBoxTableViewer.this.setChecked(item);
            }
        };
        lazyContentProvider.setSortProperty(this.getSortProperty());
        final LazyContentProvider lazyContentProviderForOnlySelected = new LazyContentProvider<SECONDARY>(this.secondaryClazz, (TableViewer)panel.getViewer()){
            private List<SECONDARY> secondarys;

            protected int getRowCount() {
                if (MultiSelectCheckBoxTableViewer.this.joitings.isEmpty()) {
                    this.secondarys = Collections.emptyList();
                    return 0;
                }
                this.secondarys = new ArrayList(MultiSelectCheckBoxTableViewer.this.joitings.size());
                try {
                    for (Object joiting : MultiSelectCheckBoxTableViewer.this.joitings) {
                        Object secondary = MultiSelectCheckBoxTableViewer.this.getSecondaryFromJoiting(joiting);
                        if (secondary == null) {
                            secondary = MultiSelectCheckBoxTableViewer.this.createEmptySecondary(joiting);
                        }
                        boolean mustAdd = true;
                        if (MultiSelectCheckBoxTableViewer.this.secondaryFilterElement != null && StringUtils.isNotEmpty((String)MultiSelectCheckBoxTableViewer.this.secondaryFilterElement.getValue())) {
                            mustAdd = false;
                            String[] stringArray = MultiSelectCheckBoxTableViewer.this.secondaryFilterElement.getProperty();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String field = stringArray[n2];
                                Object value = PropertyUtils.getProperty(secondary, (String)field);
                                if (value != null && value.toString().contains(MultiSelectCheckBoxTableViewer.this.secondaryFilterElement.getValue())) {
                                    mustAdd = true;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        if (!mustAdd) continue;
                        this.secondarys.add(secondary);
                    }
                    log.debug("secondarys size={}", (Object)this.secondarys.size());
                    final int asc = this.isAscending() ? 1 : -1;
                    Collections.sort(this.secondarys, new Comparator<SECONDARY>(){

                        @Override
                        public int compare(SECONDARY o1, SECONDARY o2) {
                            try {
                                return ComparatorUtils.NATURAL_COMPARATOR.compare(PropertyUtils.getProperty(o1, (String)MultiSelectCheckBoxTableViewer.this.getSortProperty()), PropertyUtils.getProperty(o2, (String)MultiSelectCheckBoxTableViewer.this.getSortProperty())) * asc;
                            }
                            catch (Exception e) {
                                log.trace("Exception while filtering and sorting on select secondarys of catalog list: {}", (Throwable)e);
                                return 0;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.trace("Exception while filtering and sorting on select secondarys of catalog list: {}", (Throwable)e);
                }
                return this.secondarys.size();
            }

            protected List<SECONDARY> getRows(int minIndex, int maxIndex) {
                return this.secondarys.subList(minIndex, Math.min(this.secondarys.size(), maxIndex));
            }

            protected void customUpdate(TableItem item) {
                MultiSelectCheckBoxTableViewer.this.setChecked(item);
            }
        };
        ((TableViewer)panel.getViewer()).setContentProvider((IContentProvider)lazyContentProvider);
        ((TableViewer)panel.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(panel.getColumns()));
        ((TableViewer)panel.getViewer()).getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    try {
                        Object joiting = LibActivator.getDefault().getActualClassResolver().getInstance(MultiSelectCheckBoxTableViewer.this.joitingClazz);
                        joiting = MultiSelectCheckBoxTableViewer.this.setPrimary(joiting, MultiSelectCheckBoxTableViewer.this.primary);
                        joiting = MultiSelectCheckBoxTableViewer.this.setSecondary(joiting, ((TableItem)event.item).getData());
                        if (((TableItem)event.item).getChecked()) {
                            if (!MultiSelectCheckBoxTableViewer.this.joitings.contains(joiting)) {
                                MultiSelectCheckBoxTableViewer.this.joitings.add(joiting);
                            }
                        } else {
                            MultiSelectCheckBoxTableViewer.this.joitings.remove(joiting);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        panel.setInput(null);
        panel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        final Button showOnlySelectedDeptsButton = new Button(parent, 32);
        showOnlySelectedDeptsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int sortDirection = ((TableViewer)panel.getViewer()).getTable().getSortDirection();
                if (showOnlySelectedDeptsButton.getSelection()) {
                    ((TableViewer)panel.getViewer()).setContentProvider((IContentProvider)lazyContentProviderForOnlySelected);
                } else {
                    ((TableViewer)panel.getViewer()).setContentProvider((IContentProvider)lazyContentProvider);
                }
                ((IOrderedContentProvider)((TableViewer)panel.getViewer()).getContentProvider()).setAscending(1024 == sortDirection);
                ((TableViewer)panel.getViewer()).refresh(true);
            }
        });
        showOnlySelectedDeptsButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        showOnlySelectedDeptsButton.setText(this.getTextForSelectedCheckBox());
        parent.layout(true, true);
    }

    public Map<JOITING, String> getChangedMap(PRIMARY current) {
        if (this.joitings != null && this.joitingsBeginState != null) {
            List added = ListUtils.subtract(this.joitings, this.joitingsBeginState);
            List removed = ListUtils.subtract(this.joitingsBeginState, this.joitings);
            HashMap payForbiddanceMap = new HashMap();
            for (Object joiting : added) {
                if (!ObjectUtils.equals(this.getPrimaryFromJoiting(joiting), current)) {
                    this.setPrimary(joiting, current);
                }
                payForbiddanceMap.put(joiting, "ADD");
            }
            for (Object joiting : removed) {
                if (!ObjectUtils.equals(this.getPrimaryFromJoiting(joiting), current)) {
                    this.setPrimary(joiting, current);
                }
                payForbiddanceMap.put(joiting, "REMOVE");
            }
            return payForbiddanceMap;
        }
        return MapUtils.EMPTY_MAP;
    }

    protected void setChecked(final TableItem item) {
        log.debug("event ={}", item.getData());
        Object joiting = CollectionUtils.find(this.joitings, (Predicate)new Predicate(){

            public boolean evaluate(Object joiting) {
                return ObjectUtils.equals(MultiSelectCheckBoxTableViewer.this.getSecondaryFromJoiting(joiting), (Object)item.getData());
            }
        });
        item.setChecked(this.checkSecondaryOnEmpty(item.getData()) || joiting != null);
    }
}

