/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.connect;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.Connect;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.utils.JaxbUtil;
import su.artix.discountmanagercore.holders.ProperiesType;
import su.artix.discountmanagercore.holders.PropertiesHolder;

public class EditConnectXmlFile {
    private static final Logger log = LoggerFactory.getLogger(EditConnectXmlFile.class);

    public static void saveConnections(List<Connect> connections) {
        if (connections != null) {
            ArrayList<Connect> cashConnections = new ArrayList<Connect>();
            ArrayList<Connect> csConnections = new ArrayList<Connect>();
            for (Connect connect : connections) {
                if (connect.isCashServerConnect()) {
                    csConnections.add(connect);
                    continue;
                }
                cashConnections.add(connect);
            }
            DomainCollections domainCollections = new DomainCollections();
            domainCollections.setDomainCollection(cashConnections);
            String cashPath = PropertiesHolder.INSTANCE.getPath(ProperiesType.CASH_CONNECTION);
            if (cashPath != null) {
                JaxbUtil.INSTANCE.exportToXML(cashPath, domainCollections);
            } else {
                log.error("Couldn't save connections - path is null");
            }
            String serverPath = PropertiesHolder.INSTANCE.getPath(ProperiesType.SERVER_CONNECTION);
            if (serverPath != null) {
                domainCollections.setDomainCollection(csConnections);
                JaxbUtil.INSTANCE.exportToXML(serverPath, domainCollections);
            } else {
                log.error("Couldn't save connections - path is null");
            }
        }
    }

    public static List<Connect> readConnections(ProperiesType type) {
        List<Object> conns = new ArrayList<Connect>();
        try {
            String url = PropertiesHolder.INSTANCE.getPath(type);
            if (url != null) {
                File file = new File(url);
                DomainCollections importFromXml = JaxbUtil.INSTANCE.importFromXml(file.getCanonicalPath());
                conns = importFromXml.getDomainCollection();
            } else {
                log.error("Couldn't load connections - path is null");
            }
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        for (Connect c : conns) {
            c.setCashServerConnect(type == ProperiesType.SERVER_CONNECTION);
        }
        return conns;
    }

    public static List<Connect> readAllConnections() {
        List<Connect> conns = EditConnectXmlFile.readConnections(ProperiesType.SERVER_CONNECTION);
        conns.addAll(EditConnectXmlFile.readConnections(ProperiesType.CASH_CONNECTION));
        return conns;
    }
}

