/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.menutree;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import ru.ssa.artixadmin.action.menutree.AddMenuActionFromList;
import ru.ssa.artixadmin.action.menutree.AddSubMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.DeleteMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.DownAction;
import ru.ssa.artixadmin.action.menutree.EditMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.RefreshMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.UpAction;
import su.artix.yuki.images.ArtixAdminImages;

public class MenuActionGroup
extends ActionGroup {
    private IAction refreshMenuAction;
    private IAction upAction;
    private IAction downAction;
    private IAction addSubMenuTreeAction;
    private IAction addMenuActionFromList;
    private IAction editMenuTreeAction;
    private IAction deleteMenuTreeAction;

    private void makeActions() {
        this.refreshMenuAction = new RefreshMenuTreeAction();
        this.upAction = new UpAction();
        this.downAction = new DownAction();
        this.addSubMenuTreeAction = new AddSubMenuTreeAction();
        this.addMenuActionFromList = new AddMenuActionFromList();
        this.editMenuTreeAction = new EditMenuTreeAction();
        this.deleteMenuTreeAction = new DeleteMenuTreeAction();
        this.setSmallIcons();
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        toolBar.add(this.refreshMenuAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add(this.upAction);
        toolBar.add(this.downAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add(this.addSubMenuTreeAction);
        toolBar.add(this.addMenuActionFromList);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add(this.editMenuTreeAction);
        toolBar.add(this.deleteMenuTreeAction);
    }

    protected void fillViewMenu(IMenuManager menu) {
        menu.add(this.refreshMenuAction);
        menu.add(this.upAction);
        menu.add(this.downAction);
        menu.add(this.addSubMenuTreeAction);
        menu.add(this.addMenuActionFromList);
        menu.add(this.editMenuTreeAction);
        menu.add(this.deleteMenuTreeAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    public MenuActionGroup() {
        this.makeActions();
    }

    public IAction getUpAction() {
        return this.upAction;
    }

    public IAction getDownAction() {
        return this.downAction;
    }

    public IAction getEditMenuTreeAction() {
        return this.editMenuTreeAction;
    }

    public IAction getRefreshMenuAction() {
        return this.refreshMenuAction;
    }

    public IAction getAddSubMenuTreeAction() {
        return this.addSubMenuTreeAction;
    }

    public IAction getAddMenuActionFromList() {
        return this.addMenuActionFromList;
    }

    public IAction getDeleteMenuTreeAction() {
        return this.deleteMenuTreeAction;
    }

    public void setBigIcons() {
        this.refreshMenuAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/24x24/refresh"));
        this.upAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/24x24/up"));
        this.downAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/24x24/down"));
        this.addSubMenuTreeAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/24x24/child_add"));
        this.addMenuActionFromList.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/24x24/action_add"));
        this.editMenuTreeAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/24x24/edit"));
        this.deleteMenuTreeAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/24x24/delete"));
    }

    public void setSmallIcons() {
        this.refreshMenuAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/refresh"));
        this.upAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/up"));
        this.downAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/down"));
        this.addSubMenuTreeAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/child_add"));
        this.addMenuActionFromList.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/action_add"));
        this.editMenuTreeAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/edit"));
        this.deleteMenuTreeAction.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/delete"));
    }

    public void setDisabledAll() {
        this.upAction.setEnabled(false);
        this.downAction.setEnabled(false);
        this.addSubMenuTreeAction.setEnabled(false);
        this.addMenuActionFromList.setEnabled(false);
        this.editMenuTreeAction.setEnabled(false);
        this.deleteMenuTreeAction.setEnabled(false);
    }

    public void setEnabledAll() {
        this.upAction.setEnabled(true);
        this.downAction.setEnabled(true);
        this.addSubMenuTreeAction.setEnabled(true);
        this.addMenuActionFromList.setEnabled(true);
        this.editMenuTreeAction.setEnabled(true);
        this.deleteMenuTreeAction.setEnabled(true);
    }
}

