/*
 * Decompiled with CFR 0.152.
 */
package cashserver.cashregistry.rest.repository;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.repository.SecurityRoleRepository;
import su.artix.cashserver.rest.client.IClientGetter;

public class SecurityRoleRepositoryRest
implements SecurityRoleRepository {
    private IClientGetter clientGetter;

    public <S extends SecurityRole> S save(S entity) {
        if (this.exists(entity.getRoleName())) {
            this.clientGetter.getClient().getSecurityRoleEntity().updateSecurityRole(entity.getName(), entity);
        } else {
            this.clientGetter.getClient().getSecurityRoleEntity().addSecurityRole(entity);
        }
        return entity;
    }

    public <S extends SecurityRole> Iterable<S> save(Iterable<S> entities) {
        for (SecurityRole securityRole : entities) {
            this.save(securityRole);
        }
        return entities;
    }

    public SecurityRole findOne(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return this.clientGetter.getClient().getSecurityRoleEntity().getSecurityRole(id);
    }

    public boolean exists(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        return this.clientGetter.getClient().getSecurityRoleEntity().existsSecurityRole(id);
    }

    public long count() {
        return this.clientGetter.getClient().getSecurityRoleEntity().countSecurityRoles();
    }

    public void delete(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            this.clientGetter.getClient().getSecurityRoleEntity().removeSecurityRole(id);
        }
    }

    public void delete(SecurityRole entity) {
        this.delete(entity.getRoleName());
    }

    public void delete(Iterable<? extends SecurityRole> entities) {
        for (SecurityRole securityRole : entities) {
            this.delete(securityRole.getRoleName());
        }
    }

    public List<SecurityRole> findAll() {
        return this.clientGetter.getClient().getSecurityRoleEntity().getSecurityRoles();
    }

    public SecurityRole findByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        return this.clientGetter.getClient().getSecurityRoleEntity().getSecurityRole(name);
    }

    public Iterable<SecurityRole> findAll(Sort sort) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Page<SecurityRole> findAll(Pageable pageable) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterable<SecurityRole> findAll(Iterable<String> ids) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void deleteAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IClientGetter getClientGetter() {
        return this.clientGetter;
    }

    public void setClientGetter(IClientGetter clientGetter) {
        this.clientGetter = clientGetter;
    }
}

