/*
 * Decompiled with CFR 0.152.
 */
package cashserver.cashregistry.rest.repository;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;
import su.artix.cashserver.core.cashregistry.repository.SecurityPermissionRepository;
import su.artix.cashserver.rest.client.IClientGetter;

public class SecurityPermissionRepositoryRest
implements SecurityPermissionRepository {
    private IClientGetter clientGetter;

    public <S extends SecurityPermission> S save(S entity) {
        if (this.exists(entity.getId())) {
            this.clientGetter.getClient().getSecurityPermissionEntity().updateSecurityPermission(entity.getId(), entity);
        } else {
            this.clientGetter.getClient().getSecurityPermissionEntity().addSecurityPermission(entity);
        }
        return entity;
    }

    public <S extends SecurityPermission> Iterable<S> save(Iterable<S> entities) {
        for (SecurityPermission securityPermission : entities) {
            if (securityPermission.getSecurityObject() == null) continue;
            this.save(securityPermission);
        }
        return entities;
    }

    public SecurityPermission findOne(Integer id) {
        if (id == null) {
            return null;
        }
        return this.clientGetter.getClient().getSecurityPermissionEntity().getSecurityPermission(id);
    }

    public boolean exists(Integer id) {
        if (id == null) {
            return false;
        }
        return this.clientGetter.getClient().getSecurityPermissionEntity().existsSecurityPermission(id);
    }

    public List<SecurityPermission> findAll() {
        return this.clientGetter.getClient().getSecurityPermissionEntity().getSecurityPermissions();
    }

    public long count() {
        return this.clientGetter.getClient().getSecurityPermissionEntity().countSecurityPermissions();
    }

    public void delete(Integer id) {
        if (id != null) {
            this.clientGetter.getClient().getSecurityPermissionEntity().removeSecurityPermission(id);
        }
    }

    public void delete(SecurityPermission entity) {
        this.delete(entity.getId());
    }

    public void delete(Iterable<? extends SecurityPermission> entities) {
        for (SecurityPermission securityPermission : entities) {
            this.delete(securityPermission.getId());
        }
    }

    public SecurityPermission findById(Integer id) {
        if (id == null) {
            return null;
        }
        return this.clientGetter.getClient().getSecurityPermissionEntity().getSecurityPermission(id);
    }

    public Iterable<SecurityPermission> findAll(Sort sort) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Page<SecurityPermission> findAll(Pageable pageable) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterable<SecurityPermission> findAll(Iterable<Integer> ids) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void deleteAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IClientGetter getClientGetter() {
        return this.clientGetter;
    }

    public void setClientGetter(IClientGetter clientGetter) {
        this.clientGetter = clientGetter;
    }
}

