/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.directory;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.DomainUtils;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import ru.ssa.cashadmin.utils.ArtixFilter;
import ru.ssa.cashadmin.utils.FilterRestriction;
import su.artix.widgets.FilterElement;
import su.artix.yuki.model.ChangeIdValueException;
import su.artix.yuki.model.DuplicateValueException;
import su.artix.yuki.model.OneElement;
import su.artix.yuki.model.SearchResult;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.model.directory.DirectoryEditModel;

public class DirectoryModel<T>
implements DirectoryEditModel<T> {
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(DirectoryModel.class);
    private Class<T> clazz;

    public DirectoryModel(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    @Override
    public void firePropertyChange(DirectoryAction prop, Object old, Object newValue) {
        if (this.listeners.hasListeners(prop.toString())) {
            this.listeners.firePropertyChange(prop.toString(), old, newValue);
        }
    }

    @Override
    public T update(T obj) throws ExecuteQueryException {
        return (T)DaoFactory.getDAO(this.clazz).update(obj);
    }

    @Override
    public T save(T obj) throws ExecuteQueryException {
        return (T)DaoFactory.getDAO(this.clazz).save(obj);
    }

    @Override
    public void doUpdate(T obj) throws ExecuteQueryException {
        obj = this.update(obj);
        this.firePropertyChange(DirectoryAction.UPDATE, null, obj);
        this.cascadeRefresh();
    }

    @Override
    public void cascadeRefresh() {
    }

    protected void doAfterChangeId(Object oldId, T obj) throws ExecuteQueryException {
    }

    protected void changeId(T obj, Object oldId, Object newId, String ... idField) throws ChangeIdValueException {
        try {
            if (idField == null) {
                idField = new String[]{DomainUtils.getIdColum(obj.getClass())};
            }
            DaoFactory.getDAO(this.clazz).changeId(oldId, newId, idField);
            this.firePropertyChange(DirectoryAction.CHANGE_ID, null, obj);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ChangeIdValueException(oldId, newId, e);
        }
    }

    @Override
    public void doAdd(T obj) throws DuplicateValueException, ExecuteQueryException {
        Object id = DomainUtils.getIdValue(obj);
        if (DaoFactory.getDAO(this.clazz).getById(id) != null) {
            throw new DuplicateValueException(id.toString());
        }
        obj = this.save(obj);
        this.firePropertyChange(DirectoryAction.ADD, null, obj);
        this.cascadeRefresh();
    }

    @Override
    public void doSave(T obj, Object oldId, T old, String ... idField) throws DuplicateValueException, ChangeIdValueException, ExecuteQueryException {
        Object newId = DomainUtils.getIdValue(obj);
        if (!oldId.equals(newId)) {
            if (DaoFactory.getDAO(this.clazz).getById(newId) != null) {
                throw new DuplicateValueException(newId.toString());
            }
            this.changeId(obj, oldId, newId, idField);
            this.doAfterChangeId(oldId, obj);
        }
        obj = this.update(obj);
        this.firePropertyChange(DirectoryAction.UPDATE, null, obj);
        this.cascadeRefresh();
    }

    @Override
    public void doRemove(T obj) throws ExecuteQueryException {
        this.delete(obj);
        this.firePropertyChange(DirectoryAction.REMOVE, null, obj);
        this.cascadeRefresh();
    }

    @Override
    public void delete(T obj) throws ExecuteQueryException {
        DaoFactory.getDAO(this.clazz).delete(obj);
    }

    @Override
    public void doRemoveAll(Collection<T> obj) throws ExecuteQueryException {
        DaoFactory.getDAO(this.clazz).deleteAll(obj);
        this.cascadeRefresh();
    }

    @Override
    public void doRefresh() {
        this.firePropertyChange(DirectoryAction.REFRESH, null, null);
        DaoFactory.getDAO(this.clazz).clearExistsIds();
        this.cascadeRefresh();
    }

    @Override
    public List<T> getList() {
        return this.getList(null, false, null, null, null);
    }

    @Override
    public Object getPrimaryIdValue(Object item) {
        return DomainUtils.getIdValue((Object)item);
    }

    @Override
    public List<T> getList(Object state) {
        return this.getList(null, false, state, null, null);
    }

    @Override
    public List<T> getList(String sortby, boolean sortAsc) {
        return this.getList(sortby, sortAsc, null, null, null);
    }

    @Override
    public List<T> getList(String sortby, boolean sortAsc, Object state) {
        return this.getList(sortby, sortAsc, state, null, null);
    }

    @Override
    public List<T> getList(String sortby, boolean sortAsc, Object state, Integer firstResult, Integer maxResults) {
        if (state instanceof ArtixFilter) {
            ArtixFilter filter = (ArtixFilter)state;
            this.completeState(filter);
            try {
                return DaoFactory.getDAO(this.clazz).getList(filter, sortby, sortAsc, firstResult, maxResults);
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        if (state instanceof OneElement) {
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                list.add(DaoFactory.getDAO(this.clazz).getById(DomainUtils.getIdValue((Object)((OneElement)state).getElement())));
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return list;
        }
        if (state instanceof SearchResult) {
            SearchResult result = (SearchResult)state;
            return result.getResult(firstResult, maxResults);
        }
        if (state instanceof FilterElement) {
            try {
                ArtixFilter<T> filter = this.getFilter((FilterElement)state);
                return DaoFactory.getDAO(this.clazz).getList(filter, sortby, sortAsc, firstResult, maxResults);
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        try {
            return DaoFactory.getDAO(this.clazz).getList(sortby, sortAsc, state, firstResult, maxResults);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected void completeState(ArtixFilter<T> state) {
    }

    private ArtixFilter<T> getFilter(FilterElement state) {
        try {
            ArtixFilter filter = new ArtixFilter(this.clazz);
            return this.addFilter(filter, state);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public ArtixFilter<T> addFilter(ArtixFilter<T> filter, FilterElement state) {
        if (state != null && state.getProperty() != null) {
            try {
                boolean first = true;
                String[] stringArray = state.getProperty();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String property = stringArray[n2];
                    FilterRestriction.LinkCondition linkCondition = first ? FilterRestriction.LinkCondition.unique : FilterRestriction.LinkCondition.or;
                    filter.add(new FilterRestriction(property, (Object)state.getValue(), linkCondition, FilterRestriction.Condition.like, Boolean.valueOf(false)));
                    first = false;
                    ++n2;
                }
                return filter;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public Long getItemCount(Object state) {
        if (state instanceof ArtixFilter) {
            ArtixFilter filter = (ArtixFilter)state;
            this.completeState(filter);
            try {
                return DaoFactory.getDAO(this.clazz).count(filter);
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
                return 0L;
            }
        }
        if (state instanceof OneElement) {
            return 1L;
        }
        if (state instanceof SearchResult) {
            return ((SearchResult)state).getResult().size();
        }
        if (state instanceof FilterElement) {
            try {
                ArtixFilter<T> filter = this.getFilter((FilterElement)state);
                return DaoFactory.getDAO(this.clazz).count(filter);
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
                return 0L;
            }
        }
        try {
            return DaoFactory.getDAO(this.clazz).count(state);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public List getProjList(String property, T state) {
        try {
            return DaoFactory.getDAO(this.clazz).getProjectionList(property, state);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public T getById(Object id) {
        try {
            return (T)DaoFactory.getDAO(this.clazz).getById(id);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<T> findByHSQL(String hsql, Object[] param) {
        try {
            return DaoFactory.getDAO(this.clazz).findByHSQL(hsql, param);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Object getNextId() {
        Object max = null;
        try {
            max = DaoFactory.getDAO(this.clazz).getMaxId();
        }
        catch (ExecuteQueryException e) {
            log.error("get max value error", (Throwable)e);
        }
        return this.generateNext(DomainUtils.getTypeId(this.clazz), max);
    }

    @Override
    public Object getNext(String field, T state) {
        Object max = null;
        try {
            max = DaoFactory.getDAO(this.clazz).getMax(field, state);
        }
        catch (ExecuteQueryException e) {
            log.error("get max value error", (Throwable)e);
        }
        return this.generateNext(FieldUtils.getField(this.clazz, (String)field, (boolean)true).getType(), max);
    }

    private Object generateNext(Class<?> type, Object obj) {
        if (type.isAssignableFrom(Integer.class)) {
            if (obj == null) {
                obj = 0;
            }
            if (obj instanceof Integer) {
                return this.getNextAsInteger((Integer)obj);
            }
            if (obj instanceof String) {
                return Integer.valueOf(this.getNextAsString((String)obj));
            }
        } else if (type.isAssignableFrom(Long.class)) {
            if (obj == null) {
                obj = 0L;
            }
            if (obj instanceof Long) {
                return this.getNextAsLong((Long)obj);
            }
            if (obj instanceof String) {
                return Long.valueOf(this.getNextAsString((String)obj));
            }
        } else if (type.isAssignableFrom(String.class)) {
            if (obj == null) {
                obj = "0";
            }
            if (obj instanceof String) {
                return this.getNextAsString((String)obj);
            }
            if (obj instanceof Integer) {
                return String.valueOf(this.getNextAsInteger((Integer)obj));
            }
        }
        throw new RuntimeException("Oups,i don't know next value for class:" + obj.getClass() + ". Max value=" + obj);
    }

    private Long getNextAsLong(Long obj) {
        return obj + 1L;
    }

    private String getNextAsString(String obj) {
        try {
            return String.valueOf(Long.parseLong(obj) + 1L);
        }
        catch (NumberFormatException e) {
            log.error("convert string int to int", (Throwable)e);
            return String.valueOf(obj) + "1";
        }
    }

    private Integer getNextAsInteger(Integer obj) {
        return obj + 1;
    }

    @Override
    public void saveCollection(Collection<T> collection) {
        DaoFactory.getDAO(this.clazz).saveCollection(collection);
    }

    @Override
    public void updateActionsMap(Map<T, String> map) {
        DaoFactory.getDAO(this.clazz).updateActionsMap(map);
    }

    @Override
    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DirectoryModel [clazz=");
        builder.append(this.clazz);
        builder.append("]");
        return builder.toString();
    }

    public List<?> getAuditList() {
        return Collections.emptyList();
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Integer firstResult, Integer maxResults) {
        try {
            return DaoFactory.getDAO(this.clazz).findByNamedQuery(queryName, firstResult, maxResults);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Object getAuditRevisionItem(int revision) {
        return DaoFactory.getDAO(this.clazz).getAuditRevisionEntry(revision);
    }

    @Override
    public List<?> getAuditItemList(String sortby, boolean sortAsc, Object state, Integer firstResult, Integer maxResults) {
        return DaoFactory.getDAO(this.clazz).getAuditList(state, firstResult.intValue(), maxResults.intValue(), sortby, sortAsc);
    }

    @Override
    public void setStoreId(String id) {
    }
}

