/*
 * Decompiled with CFR 0.152.
 */
package su.artix.artixadmin.connection;

import org.springframework.util.Assert;
import su.artix.cashserver.core.cashregistry.domain.CashServerMode;

public class ArtixAdminContextHolder {
    private static final ThreadLocal<String> CONTEXT_HOLDER = new ThreadLocal();
    private static boolean cashserver;
    private static volatile String userName;
    private static volatile boolean hibernateSessionInited;
    private static CashServerMode cashServerMode;

    static {
        hibernateSessionInited = false;
        cashServerMode = new CashServerMode();
    }

    private ArtixAdminContextHolder() {
    }

    public static void setConnectionId(String connectionId) {
        Assert.notNull((Object)connectionId, (String)"connectionId cannot be null");
        CONTEXT_HOLDER.set(connectionId);
    }

    public static String getConnectionId() {
        return CONTEXT_HOLDER.get();
    }

    public static void clearConnectionId() {
        CONTEXT_HOLDER.remove();
    }

    public static boolean isCashserver() {
        return cashserver;
    }

    public static void setCashserver(boolean cashserver) {
        ArtixAdminContextHolder.cashserver = cashserver;
    }

    public static String getUserName() {
        return userName;
    }

    public static void setUserName(String userName) {
        ArtixAdminContextHolder.userName = userName;
    }

    public static boolean isHibernateSessionInited() {
        return hibernateSessionInited;
    }

    public static void setHibernateSessionInited(boolean hibernateSessionInited) {
        ArtixAdminContextHolder.hibernateSessionInited = hibernateSessionInited;
    }

    public static CashServerMode getCashServerMode() {
        return cashServerMode;
    }

    public static void setCashServerMode(CashServerMode cashServerMode) {
        ArtixAdminContextHolder.cashServerMode = cashServerMode;
    }
}

