/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.I2CPort;
import gnu.io.I2CPortEvent;
import gnu.io.I2CPortEventListener;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

final class I2C
extends I2CPort {
    private int fd;
    static boolean dsrFlag;
    private final I2COutputStream out = new I2COutputStream();
    private final I2CInputStream in = new I2CInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout = 0;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private I2CPortEventListener SPEventListener;
    private MonitorThread monThread;
    private int dataAvailable = 0;

    private static native void Initialize();

    public I2C(String string) throws PortInUseException {
        this.fd = this.open(string);
    }

    private native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setI2CPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        this.nativeSetI2CPortParams(n, n2, n3, n4);
        this.speed = n;
        this.dataBits = n2;
        this.stopBits = n3;
        this.parity = n4;
    }

    private native void nativeSetI2CPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    public int getBaudRate() {
        return this.speed;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setFlowControlMode(int n) {
        try {
            this.setflowcontrol(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.flowmode = n;
    }

    public int getFlowControlMode() {
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return 0;
    }

    public native int NativegetReceiveTimeout();

    public native boolean NativeisReceiveTimeoutEnabled();

    public native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    public void disableReceiveTimeout() {
        this.enableReceiveTimeout(0);
    }

    public void enableReceiveTimeout(int n) {
        if (n >= 0) {
            this.timeout = n;
            this.NativeEnableReceiveTimeoutThreshold(n, this.threshold, this.InputBuffer);
        } else {
            System.out.println("Invalid timeout");
        }
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.NativeisReceiveTimeoutEnabled();
    }

    public int getReceiveTimeout() {
        return this.NativegetReceiveTimeout();
    }

    public void enableReceiveThreshold(int n) {
        if (n >= 0) {
            this.threshold = n;
            this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
        } else {
            System.out.println("Invalid Threshold");
        }
    }

    public void disableReceiveThreshold() {
        this.enableReceiveThreshold(0);
    }

    public int getReceiveThreshold() {
        return this.threshold;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.threshold > 0;
    }

    public void setInputBufferSize(int n) {
        this.InputBuffer = n;
    }

    public int getInputBufferSize() {
        return this.InputBuffer;
    }

    public void setOutputBufferSize(int n) {
        this.OutputBuffer = n;
    }

    public int getOutputBufferSize() {
        return this.OutputBuffer;
    }

    public native boolean isDTR();

    public native void setDTR(boolean var1);

    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    public native boolean isCTS();

    public native boolean isDSR();

    public native boolean isCD();

    public native boolean isRI();

    public native boolean isRTS();

    public native void sendBreak(int var1);

    private native void writeByte(int var1) throws IOException;

    private native void writeArray(byte[] var1, int var2, int var3) throws IOException;

    private native void drain() throws IOException;

    private native int nativeavailable() throws IOException;

    private native int readByte() throws IOException;

    private native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    public void sendEvent(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.dataAvailable = 1;
                if (this.monThread.Data) break;
                return;
            }
            case 2: {
                if (this.monThread.Output) break;
                return;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return;
            }
            case 5: {
                if (this.monThread.RI) break;
                return;
            }
            case 6: {
                if (this.monThread.CD) break;
                return;
            }
            case 7: {
                if (this.monThread.OE) break;
                return;
            }
            case 8: {
                if (this.monThread.PE) break;
                return;
            }
            case 9: {
                if (this.monThread.FE) break;
                return;
            }
            case 10: {
                if (this.monThread.BI) break;
                return;
            }
            default: {
                System.err.println("unknown event:" + n);
                return;
            }
        }
        I2CPortEvent i2CPortEvent = new I2CPortEvent(this, n, !bl, bl);
        if (this.SPEventListener != null) {
            this.SPEventListener.I2CEvent(i2CPortEvent);
        }
    }

    public void addEventListener(I2CPortEventListener i2CPortEventListener) throws TooManyListenersException {
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = i2CPortEventListener;
        this.monThread = new MonitorThread();
        this.monThread.start();
    }

    public void removeEventListener() {
        this.SPEventListener = null;
        if (this.monThread != null) {
            this.monThread.interrupt();
            this.monThread = null;
        }
    }

    public void notifyOnDataAvailable(boolean bl) {
        this.monThread.Data = bl;
    }

    public void notifyOnOutputEmpty(boolean bl) {
        this.monThread.Output = bl;
    }

    public void notifyOnCTS(boolean bl) {
        this.monThread.CTS = bl;
    }

    public void notifyOnDSR(boolean bl) {
        this.monThread.DSR = bl;
    }

    public void notifyOnRingIndicator(boolean bl) {
        this.monThread.RI = bl;
    }

    public void notifyOnCarrierDetect(boolean bl) {
        this.monThread.CD = bl;
    }

    public void notifyOnOverrunError(boolean bl) {
        this.monThread.OE = bl;
    }

    public void notifyOnParityError(boolean bl) {
        this.monThread.PE = bl;
    }

    public void notifyOnFramingError(boolean bl) {
        this.monThread.FE = bl;
    }

    public void notifyOnBreakInterrupt(boolean bl) {
        this.monThread.BI = bl;
    }

    private native void nativeClose();

    public void close() {
        this.setDTR(false);
        this.setDSR(false);
        this.nativeClose();
        super.close();
        this.fd = 0;
    }

    protected void finalize() {
        if (this.fd > 0) {
            this.close();
        }
    }

    static {
        System.loadLibrary("rxtxI2C");
        I2C.Initialize();
        dsrFlag = false;
    }

    class I2CInputStream
    extends InputStream {
        I2CInputStream() {
        }

        public int read() throws IOException {
            I2C.this.dataAvailable = 0;
            return I2C.this.readByte();
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            I2C.this.dataAvailable = 0;
            int n4 = 0;
            int[] nArray = new int[]{byArray.length, I2C.this.InputBuffer, n2};
            for (n3 = 0; nArray[n3] == 0 && n3 < nArray.length; ++n3) {
            }
            n4 = nArray[n3];
            while (n3 < nArray.length) {
                if (nArray[n3] > 0) {
                    n4 = Math.min(n4, nArray[n3]);
                }
                ++n3;
            }
            if ((n4 = Math.min(n4, I2C.this.threshold)) == 0) {
                n4 = 1;
            }
            int n5 = this.available();
            int n6 = I2C.this.readArray(byArray, n, n4);
            return n6;
        }

        public int available() throws IOException {
            return I2C.this.nativeavailable();
        }
    }

    class I2COutputStream
    extends OutputStream {
        I2COutputStream() {
        }

        public void write(int n) throws IOException {
            I2C.this.writeByte(n);
        }

        public void write(byte[] byArray) throws IOException {
            I2C.this.writeArray(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            I2C.this.writeArray(byArray, n, n2);
        }

        public void flush() throws IOException {
            I2C.this.drain();
        }
    }

    class MonitorThread
    extends Thread {
        private boolean CTS = false;
        private boolean DSR = false;
        private boolean RI = false;
        private boolean CD = false;
        private boolean OE = false;
        private boolean PE = false;
        private boolean FE = false;
        private boolean BI = false;
        private boolean Data = false;
        private boolean Output = false;

        MonitorThread() {
        }

        public void run() {
            I2C.this.eventLoop();
        }
    }
}

