/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client;

import java.net.URI;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;
import su.artix.cashserver.core.cashregistry.domain.WebUser;

public class RestInvoker {
    private static final Logger log = LoggerFactory.getLogger(RestInvoker.class);
    private static final String PROTOCOL = "http://";
    private String host;
    private String restURL;
    private String port;
    private WebUser authInfo;
    private RestOperations restTemplate;
    private HttpHeaders requestHeadersJson;
    private HttpHeaders requestHeadersFormData;

    protected void init() {
        this.requestHeadersJson = new HttpHeaders();
        this.requestHeadersJson.setContentType(MediaType.APPLICATION_JSON);
        this.requestHeadersFormData = new HttpHeaders();
        this.requestHeadersFormData.setContentType(MediaType.MULTIPART_FORM_DATA);
        if (this.authInfo != null) {
            String auth = String.valueOf(this.authInfo.getName()) + ":" + this.authInfo.getPassword();
            byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("UTF-8")));
            String authHeader = "Basic " + new String(encodedAuth);
            this.requestHeadersJson.set("Authorization", authHeader);
            this.requestHeadersFormData.set("Authorization", authHeader);
        }
    }

    protected <T, U> T exchange(String url, HttpMethod method, U entity, Class<T> returnClassType, ParameterizedTypeReference<T> returnTypeRef, HttpHeaders requestHeaders) {
        ResponseEntity response;
        URI resultUrl = URI.create(this.getURL(url));
        log.trace("{} - request to {} in progress...", (Object)method.toString(), (Object)resultUrl);
        HttpEntity requestEntity = new HttpEntity(entity, (MultiValueMap)requestHeaders);
        if (returnClassType == null && returnTypeRef == null) {
            log.error("Return type can`t be null. Parameters returnClassType and returnTypeRef can`t be null at same time");
            throw new IllegalArgumentException("\u0422\u0438\u043f \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d (\u043d\u0435 null).");
        }
        try {
            response = returnClassType == null ? this.restTemplate.exchange(resultUrl, method, requestEntity, returnTypeRef) : this.restTemplate.exchange(resultUrl, method, requestEntity, returnClassType);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        log.trace("Request response: {}", response.getBody());
        return (T)response.getBody();
    }

    protected <T, U> T exchange(String url, HttpMethod method, U entity, Class<T> returnClassType, ParameterizedTypeReference<T> returnTypeRef) {
        return this.exchange(url, method, entity, returnClassType, returnTypeRef, this.requestHeadersJson);
    }

    public <T> T invokeGet(String requesString, ParameterizedTypeReference<T> returnTypeRef) {
        return this.exchange(requesString, HttpMethod.GET, null, null, returnTypeRef);
    }

    public <T> T invokeGet(String requesString, Class<T> returnClassType) {
        return this.exchange(requesString, HttpMethod.GET, null, returnClassType, null);
    }

    public void invokeGet(String requesString) {
        this.exchange(requesString, HttpMethod.GET, null, Void.class, null);
    }

    public void invokePost(String requesString) {
        this.exchange(requesString, HttpMethod.POST, null, Void.class, null);
    }

    public <T> void invokePost(String requesString, T entity) {
        this.exchange(requesString, HttpMethod.POST, entity, Void.class, null);
    }

    public <T> void invokePostFile(String requesString, T entity) {
        this.exchange(requesString, HttpMethod.POST, entity, Void.class, null, this.requestHeadersFormData);
    }

    public <T> T invokePost(String requesString, Class<T> returnClassType) {
        return this.exchange(requesString, HttpMethod.POST, null, returnClassType, null);
    }

    public <T> T invokePost(String requesString, ParameterizedTypeReference<T> returnTypeRef) {
        return this.exchange(requesString, HttpMethod.POST, null, null, returnTypeRef);
    }

    public <T, U> T invokePost(String requesString, U entity, Class<T> returnClassType) {
        return this.exchange(requesString, HttpMethod.POST, entity, returnClassType, null);
    }

    public <T, U> T invokePost(String requesString, U entity, ParameterizedTypeReference<T> returnTypeRef) {
        return this.exchange(requesString, HttpMethod.POST, entity, null, returnTypeRef);
    }

    public void invokePut(String requesString) {
        this.exchange(requesString, HttpMethod.PUT, null, Void.class, null);
    }

    public <T> void invokePut(String requesString, T entity) {
        this.exchange(requesString, HttpMethod.PUT, entity, Void.class, null);
    }

    public <T> T invokePut(String requesString, Class<T> returnClassType) {
        return this.exchange(requesString, HttpMethod.PUT, null, returnClassType, null);
    }

    public <T> T invokePut(String requesString, ParameterizedTypeReference<T> returnTypeRef) {
        return this.exchange(requesString, HttpMethod.PUT, null, null, returnTypeRef);
    }

    public <T, U> T invokePut(String requesString, U entity, Class<T> returnClassType) {
        return this.exchange(requesString, HttpMethod.PUT, entity, returnClassType, null);
    }

    public <T, U> T invokePut(String requesString, U entity, ParameterizedTypeReference<T> returnTypeRef) {
        return this.exchange(requesString, HttpMethod.PUT, entity, null, returnTypeRef);
    }

    public void invokeDelete(String requesString) {
        this.exchange(requesString, HttpMethod.DELETE, null, Void.class, null);
    }

    public <T> void invokeDelete(String requesString, T entity) {
        this.exchange(requesString, HttpMethod.DELETE, entity, Void.class, null);
    }

    public <T> T invokeDelete(String requesString, Class<T> returnClassType) {
        return this.exchange(requesString, HttpMethod.DELETE, null, returnClassType, null);
    }

    public <T, U> T invokeDelete(String requesString, U entity, Class<T> returnClassType) {
        return this.exchange(requesString, HttpMethod.DELETE, entity, returnClassType, null);
    }

    private String getURL(String suffix) {
        return String.valueOf(this.getURL()) + suffix;
    }

    public static String urlBuild(String urlPattern, String ... params) {
        URI uri = UriComponentsBuilder.fromUriString((String)urlPattern).buildAndExpand((Object[])params).encode().toUri();
        return uri.toString();
    }

    protected String getURL() {
        return PROTOCOL + this.host + ":" + this.port + this.restURL;
    }

    public RestOperations getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getRestURL() {
        return this.restURL;
    }

    public void setRestURL(String restURL) {
        this.restURL = restURL;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setAuthInfo(WebUser authInfo) {
        this.authInfo = authInfo;
    }
}

