/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view.state;

import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.view.state.PersistState;

public class PersistTableOrderState
implements PersistState<Table> {
    private static final Logger log = LoggerFactory.getLogger(PersistTableOrderState.class);
    private IMemento memento;
    private String id;

    public PersistTableOrderState(IMemento memento, String id) {
        this.memento = memento;
        this.id = id;
    }

    @Override
    public void saveState(IMemento memento, Table composite) {
        log.trace("save state");
        IMemento stored = memento.getChild(String.valueOf(this.id) + "_order");
        memento = stored == null ? memento.createChild(String.valueOf(this.id) + "_order") : stored;
        int[] order = composite.getColumnOrder();
        int i = 0;
        while (i < order.length) {
            memento.putInteger("column_" + i, order[i]);
            ++i;
        }
    }

    @Override
    public void restoreState(Table composite) {
        log.trace("restore state");
        if (this.memento != null) {
            try {
                this.memento = this.memento.getChild(String.valueOf(this.id) + "_order");
                if (this.memento != null) {
                    int[] order = new int[composite.getColumnCount()];
                    int i = 0;
                    while (i < composite.getColumnCount()) {
                        Integer w = this.memento.getInteger("column_" + i);
                        if (w != null) {
                            order[i] = w;
                        }
                        ++i;
                    }
                    composite.setColumnOrder(order);
                }
            }
            catch (RuntimeException exception) {
                log.warn("Excetption while restore view state: {}", (Object)exception.getMessage());
            }
        }
    }
}

