/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.validator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.directory.GuiActivator;

public class JSR303Validator<T>
implements IValidator {
    private static final Logger log = LoggerFactory.getLogger(JSR303Validator.class);
    private T bean;
    private String propertyName;
    private Validator validator;
    private ControlDecoration controlDecoration;
    private static ValidatorFactory validatorFactory;
    private PropertyChangeListener changeListener;

    public static void setValidatorFactory(ValidatorFactory factory) {
        validatorFactory = factory;
    }

    public JSR303Validator(T bean, String propertyName) {
        this.bean = bean;
        this.propertyName = propertyName;
        this.controlDecoration = null;
        this.initValidator();
    }

    public JSR303Validator(T bean, String propertyName, Control control) {
        this.bean = bean;
        this.propertyName = propertyName;
        this.initValidator();
        this.createFieldDecoration(control);
    }

    public JSR303Validator(T bean, String propertyName, Control control, PropertyChangeListener listener) {
        this.bean = bean;
        this.propertyName = propertyName;
        this.changeListener = listener;
        this.initValidator();
        this.createFieldDecoration(control);
    }

    public JSR303Validator(T bean, String propertyName, Control control, PropertyChangeListener listener, IObservableValue other, Boolean isMore) {
        this.bean = bean;
        this.propertyName = propertyName;
        this.changeListener = listener;
        this.initValidator();
        this.createFieldDecoration(control);
    }

    private void createFieldDecoration(Control control) {
        this.controlDecoration = new ControlDecoration(control, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.controlDecoration.setImage(fieldDecoration.getImage());
    }

    private void initValidator() {
        if (validatorFactory == null) {
            try {
                validatorFactory = GuiActivator.getDefault().getBeanByClass(ValidatorFactory.class);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ValidationException("ValidationFactory not set and unable to initialize validation from default values", (Throwable)e);
            }
        }
        this.validator = validatorFactory.getValidator();
    }

    public IStatus validate(Object value) {
        Set validationResult = this.validator.validateValue(this.bean.getClass(), this.propertyName, value, new Class[]{Default.class});
        boolean isValid = false;
        if (!validationResult.isEmpty()) {
            String message = this.assembleErrorMessage(validationResult);
            if (this.controlDecoration != null) {
                this.controlDecoration.setDescriptionText(message);
                this.controlDecoration.show();
            }
        } else {
            if (this.controlDecoration != null) {
                this.controlDecoration.hide();
            }
            isValid = true;
        }
        log.trace("validate property={}, value={}, isValid={}, isnull={}, value class={}", new Object[]{this.propertyName, value, isValid, value == null, value == null ? "\u041f\u0443\u0441\u0442\u043e\u0435 \u043f\u043e\u043b\u0435!" : value.getClass()});
        this.notifyListener(value, isValid);
        return ValidationStatus.ok();
    }

    private void notifyListener(Object value, Boolean isValid) {
        if (this.changeListener != null) {
            this.changeListener.propertyChange(new PropertyChangeEvent(this.bean, this.propertyName, null, isValid));
        }
    }

    private String assembleErrorMessage(Set<?> validationResult) {
        String message = "";
        Iterator<?> iterator = validationResult.iterator();
        while (iterator.hasNext()) {
            ConstraintViolation violation = (ConstraintViolation)iterator.next();
            message = String.valueOf(message) + violation.getMessage();
            if (!iterator.hasNext()) continue;
            message = String.valueOf(message) + System.getProperty("line.separator");
        }
        return message;
    }

    public ControlDecoration getControlDecoration() {
        return this.controlDecoration;
    }
}

