/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors.utils;

import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import su.artix.widgets.BitCheckGroup;
import su.artix.yuki.editors.utils.BitsCheckGroupProperty;
import su.artix.yuki.editors.utils.BitsModel;

public class BitsToolTipSupport
extends ColumnViewerToolTipSupport {
    private Map<Integer, BitsModel> map;

    protected BitsToolTipSupport(ColumnViewer viewer, int style, boolean manualActivation, Map<Integer, BitsModel> map) {
        super(viewer, style, manualActivation);
        this.map = map;
    }

    protected Composite createViewerToolTipContentArea(Event event, ViewerCell cell, Composite parent) {
        Integer index = cell.getColumnIndex();
        BitsModel bitsModel = this.map.get(index);
        if (bitsModel != null) {
            this.createBitsContent(event, parent, cell, bitsModel);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            parent.setLayout((Layout)gridLayout);
        } else {
            super.createViewerToolTipContentArea(event, cell, parent);
        }
        return parent;
    }

    private void createBitsContent(Event event, Composite parent, ViewerCell cell, BitsModel bitsModel) {
        Object data = cell.getElement();
        Color bgColor = this.getBackgroundColor(event);
        BitCheckGroup checkGroup = new BitCheckGroup(parent, 0, bitsModel.getViewMap());
        if (bgColor != null) {
            checkGroup.setBackground(bgColor);
        } else {
            checkGroup.setBackground(new Color(null, 125, 44, 200));
        }
        checkGroup.setEnabled(false);
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)new BitsCheckGroupProperty().observe((Widget)checkGroup), PojoObservables.observeValue((Object)data, (String)bitsModel.getProperty()), null, null);
    }

    public boolean isHideOnMouseDown() {
        return false;
    }

    public static final void enableFor(ColumnViewer viewer, int style, Map<Integer, BitsModel> map) {
        new BitsToolTipSupport(viewer, style, false, map);
    }
}

