/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.SessionManager;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.cashserver.security.GuiElementController;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryAddAction;
import su.artix.yuki.action.DirectoryRefreshAction;
import su.artix.yuki.action.DirectorySelectEditAction;
import su.artix.yuki.action.DirectorySelectRemoveAction;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.editors.CustomValidateSelection;
import su.artix.yuki.editors.DirectorySelectDialog;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.editors.ParentDialog;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.view.DirectoryViewPanel;

public abstract class AbstractDirectorySelectDialog<T, VIEW extends DirectoryViewPanel<T, ?>>
extends ParentDialog
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(DirectorySelectDialog.class);
    private T model;
    private List<T> listModel = new ArrayList<T>();
    private T state;
    protected final Class<T> clazz;
    private DirectorySelectDialogState selectDialogState;
    @SecurityKey(title="\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c")
    protected DirectoryRefreshAction<T> refreshAction;
    @SecurityKey(title="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c")
    protected DirectoryAddAction<T> addAction;
    @SecurityKey(title="\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c")
    protected DirectorySelectEditAction<T> editAction;
    @SecurityKey(title="\u0423\u0434\u0430\u043b\u0438\u0442\u044c")
    protected DirectorySelectRemoveAction<T> removeAction;
    @SecurityKey(title="\u0422\u0430\u0431\u043b\u0438\u0446\u0430")
    protected VIEW viewPanel;
    private CustomValidateSelection selectionValidator;

    public AbstractDirectorySelectDialog(Shell parentShell, T model, Class<T> clazz, DirectorySelectDialogState selectDialogState) {
        this(parentShell, model, null, (Class<Object>)clazz, selectDialogState);
    }

    public AbstractDirectorySelectDialog(Shell parentShell, T model, T state, Class<T> clazz, DirectorySelectDialogState selectDialogState) {
        super(parentShell);
        this.setShellStyle(131184);
        this.model = model;
        this.state = state;
        this.clazz = clazz;
        if (selectDialogState == null) {
            throw new IllegalArgumentException("selectDialogState can`t be null");
        }
        this.selectDialogState = selectDialogState;
    }

    private Button createUserButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    private void dispose() {
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz).removePropertyChangeListener((PropertyChangeListener)this);
        if (this.editAction != null) {
            ((DirectoryViewPanel)((Object)this.viewPanel)).getViewer().removeSelectionChangedListener(this.editAction);
        }
        if (this.removeAction != null) {
            ((DirectoryViewPanel)((Object)this.viewPanel)).getViewer().removeSelectionChangedListener(this.removeAction);
        }
        ((DirectoryViewPanel)((Object)this.viewPanel)).getViewer().getContentProvider().dispose();
    }

    private boolean selectionValid(Object model) {
        return this.selectionValidator == null || this.selectionValidator.validate(model);
    }

    protected Control createDialogArea(Composite parent) {
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz).addPropertyChangeListener((PropertyChangeListener)this);
        if (this.selectDialogState != null) {
            ((DirectoryViewPanel)((Object)this.viewPanel)).setSelectDialogState(this.selectDialogState);
        }
        this.applyRights();
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createUserButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractDirectorySelectDialog.this.setModel(((DirectoryViewPanel)((Object)AbstractDirectorySelectDialog.this.viewPanel)).getViewer().getSelection());
                ISelection selection = ((DirectoryViewPanel)((Object)AbstractDirectorySelectDialog.this.viewPanel)).getViewer().getSelection();
                AbstractDirectorySelectDialog.this.doOk(selection);
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void doOk(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1 || this.selectDialogState.isMulti()) {
                if (this.selectionValid(structuredSelection.getFirstElement())) {
                    this.setSingleModel(structuredSelection);
                    this.setListModel(structuredSelection);
                    this.setSelectDialogState(((DirectoryViewPanel)((Object)this.viewPanel)).getSelectDialogState());
                    this.okPressed();
                } else {
                    this.cancelPressed();
                }
            } else {
                this.setErrorMessage("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
            }
        } else {
            this.setErrorMessage("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
        }
    }

    protected ToolBarManager makeToolBar(Composite parent) {
        this.refreshAction = new DirectoryRefreshAction<T>(this.clazz);
        this.addAction = new DirectoryAddAction<T>(this.clazz){

            @Override
            protected void doWithDialog(Dialog dialog) {
                if (dialog instanceof ParentDialog) {
                    ((ParentDialog)dialog).setParentDialog(AbstractDirectorySelectDialog.this);
                }
            }
        };
        Object addModel = this.getAddModel();
        if (addModel != null) {
            this.addAction.setModel(addModel);
        }
        this.editAction = new DirectorySelectEditAction<T>(this.clazz){

            @Override
            protected void doWithDialog(Dialog dialog) {
                if (dialog instanceof ParentDialog) {
                    ((ParentDialog)dialog).setParentDialog(AbstractDirectorySelectDialog.this);
                }
            }
        };
        this.removeAction = new DirectorySelectRemoveAction<T>(this.clazz);
        this.editAction.setEnabled(false);
        this.removeAction.setEnabled(false);
        ToolBarManager toolBarManager = this.createToolbar(parent, this.refreshAction, this.addAction, this.editAction, this.removeAction);
        Label titleBarSeparator = new Label(parent, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(4, 0, true, false));
        return toolBarManager;
    }

    protected Object getAddModel() {
        return null;
    }

    protected ToolBarManager createToolbar(Composite parent, Action ... actions) {
        if (actions != null && actions.length > 0) {
            ToolBar toolbar = new ToolBar(parent, 256);
            ToolBarManager toolBarManager = new ToolBarManager(toolbar);
            Action[] actionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                toolBarManager.add((IAction)action);
                ++n2;
            }
            toolBarManager.update(true);
            return toolBarManager;
        }
        return null;
    }

    protected void makeListener() {
        if (this.editAction != null) {
            ((DirectoryViewPanel)((Object)this.viewPanel)).getViewer().addSelectionChangedListener(this.editAction);
        }
        if (this.removeAction != null) {
            ((DirectoryViewPanel)((Object)this.viewPanel)).getViewer().addSelectionChangedListener(this.removeAction);
        }
    }

    protected void cancelPressed() {
        this.setSelectDialogState(((DirectoryViewPanel)((Object)this.viewPanel)).getSelectDialogState());
        super.cancelPressed();
    }

    public void applyRights() {
        log.trace("begin apply rights");
        GuiActivator.getDefault().getBeanByClass(GuiElementController.class).applyRights(this.getClass(), (Object)this);
        log.trace("end apply rights");
    }

    public void setSingleModel(IStructuredSelection structuredSelection) {
        Object obj = structuredSelection.getFirstElement();
        this.setModel(obj);
    }

    public void setListModel(IStructuredSelection structuredSelection) {
        this.listModel = new ArrayList<T>();
        Iterator iter = structuredSelection.iterator();
        while (iter.hasNext()) {
            this.listModel.add(iter.next());
        }
    }

    public boolean close() {
        this.dispose();
        return super.close();
    }

    public T getModel() {
        return this.model;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public List<T> getListModel() {
        return this.listModel;
    }

    public void setListModel(List<T> listModel) {
        this.listModel = listModel;
    }

    public T getState() {
        return this.state;
    }

    public void setState(T state) {
        this.state = state;
    }

    public DirectorySelectDialogState getSelectDialogState() {
        return this.selectDialogState;
    }

    public void setSelectDialogState(DirectorySelectDialogState selectDialogState) {
        this.selectDialogState = selectDialogState;
    }

    public CustomValidateSelection getSelectionValidator() {
        return this.selectionValidator;
    }

    public void setSelectionValidator(CustomValidateSelection selectionValidator) {
        this.selectionValidator = selectionValidator;
    }

    public VIEW getViewPanel() {
        return this.viewPanel;
    }

    public void setViewPanel(VIEW viewPanel) {
        this.viewPanel = viewPanel;
    }

    protected void doRemove(PropertyChangeEvent evt) {
    }

    protected void doRefresh() {
    }

    protected void doRefreshCascade() {
    }

    protected void doChangeId(PropertyChangeEvent evt) {
    }

    protected void doUpdate(PropertyChangeEvent evt) {
    }

    protected void doAdd(PropertyChangeEvent evt) {
    }

    @Override
    public final void propertyChange(final PropertyChangeEvent evt) {
        SessionManager.openSession(this.clazz);
        final String connectionId = ArtixAdminContextHolder.getConnectionId();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArtixAdminContextHolder.setConnectionId((String)connectionId);
                if (DirectoryAction.UPDATE.toString().equals(evt.getPropertyName())) {
                    AbstractDirectorySelectDialog.this.doUpdate(evt);
                } else if (DirectoryAction.CHANGE_ID.toString().equals(evt.getPropertyName())) {
                    AbstractDirectorySelectDialog.this.doChangeId(evt);
                } else if (DirectoryAction.ADD.toString().equals(evt.getPropertyName())) {
                    AbstractDirectorySelectDialog.this.doAdd(evt);
                } else if (DirectoryAction.REMOVE.toString().equals(evt.getPropertyName())) {
                    AbstractDirectorySelectDialog.this.doRemove(evt);
                } else if (DirectoryAction.REFRESH.toString().equals(evt.getPropertyName())) {
                    AbstractDirectorySelectDialog.this.doRefresh();
                } else if (DirectoryAction.CASCADE_REFRESH.toString().equals(evt.getPropertyName())) {
                    AbstractDirectorySelectDialog.this.doRefreshCascade();
                }
            }
        });
        SessionManager.closeSession(this.clazz);
    }

    public void setTitle(String newTitle) {
        this.getShell().setText(newTitle);
    }

    public DirectoryRefreshAction<T> getRefreshAction() {
        return this.refreshAction;
    }

    public void setRefreshAction(DirectoryRefreshAction<T> refreshAction) {
        this.refreshAction = refreshAction;
    }

    public DirectorySelectRemoveAction<T> getRemoveAction() {
        return this.removeAction;
    }

    public void setRemoveAction(DirectorySelectRemoveAction<T> removeAction) {
        this.removeAction = removeAction;
    }

    public DirectoryAddAction<T> getAddAction() {
        return this.addAction;
    }

    public void setAddAction(DirectoryAddAction<T> addAction) {
        this.addAction = addAction;
    }

    public DirectorySelectEditAction<T> getEditAction() {
        return this.editAction;
    }

    public void setEditAction(DirectorySelectEditAction<T> editAction) {
        this.editAction = editAction;
    }
}

