/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.utils.JaxbUtil;
import ru.ssa.cashadmin.domain.utils.RefreshUtil;
import su.artix.yuki.action.SecurityActionImpl;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.view.XMLFileDialog;

public class DirectoryExportAction<E>
extends SecurityActionImpl<E> {
    public static final String ID = "ru.ssa.artixadmin.action.DirectoryExportAction";
    private static final Logger log = LoggerFactory.getLogger(DirectoryExportAction.class);
    private static final int MAX_COUNT = 1000;

    public DirectoryExportAction(Class<E> cl) {
        super(cl, false);
        this.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u0444\u0430\u0439\u043b");
        ArtixAdminImages images = ArtixAdminImages.getDefault();
        this.setImageDescriptor(images.getImageDescriptor("plane/16x16/export"));
        this.setToolTipText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u0444\u0430\u0439\u043b");
        this.setEnabled(false);
    }

    public void run() {
        ISelection selection = this.window.getSelectionService().getSelection();
        int count = ((IStructuredSelection)selection).size();
        if (count > 1000) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", (String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u044d\u043a\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435 1000 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.");
        } else {
            String xmlFileName = new XMLFileDialog(8192).open();
            if (xmlFileName != null) {
                try {
                    SessionManager.openSession(this.getClazz());
                    GuiActivator.getDefault().setLoadCursor(true);
                    ArrayList<Object> collection = new ArrayList<Object>();
                    if (selection instanceof IStructuredSelection) {
                        Object[] objectArray = ((IStructuredSelection)selection).toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            Object e = RefreshUtil.refresh((Object)object);
                            collection.add(e);
                            ++n2;
                        }
                    }
                    DomainCollections domainCollections = new DomainCollections(collection);
                    JaxbUtil.INSTANCE.exportToXML(xmlFileName, domainCollections);
                    GuiActivator.getDefault().setLoadCursor(false);
                    SessionManager.closeSession(this.getClazz());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

