/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashregistry.mock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import su.artix.cashregistry.mock.SecurityRoleRepositoryMock;
import su.artix.cashregistry.mock.StubRepository;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.core.cashregistry.repository.WebUserRepository;

public class WebUserRepositoryMock
extends StubRepository<WebUser, String>
implements WebUserRepository {
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private SecurityRoleRepositoryMock roleRepository;

    public WebUser findByNameAndPassword(String name, String password) {
        return this.getUser(name, password, true);
    }

    public WebUser getUser(String name) {
        return this.getUser(name, null, false);
    }

    private WebUser getUser(final String name, String password, boolean checkPassword) {
        Object[] objects;
        String query;
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        if (!checkPassword) {
            query = "SELECT w.password, wr.securityRoleId FROM webUser w LEFT JOIN webUserRoles wr ON w.id=wr.webUserId WHERE w.id=?;";
            objects = new Object[]{name};
        } else {
            query = "SELECT w.password, wr.securityRoleId FROM webUser w LEFT JOIN webUserRoles wr ON w.id=wr.webUserId WHERE w.id=? AND w.password=?;";
            objects = new Object[]{name, password};
        }
        final WebUser webUser = new WebUser();
        this.jdbcTemplate.query(query, objects, (RowMapper)new RowMapper<WebUser>(){

            public WebUser mapRow(ResultSet rs, int arg1) throws SQLException {
                SecurityRole role;
                if (webUser.getName() == null) {
                    webUser.setName(name);
                    webUser.setPassword(rs.getString(1));
                    webUser.setSecurityRoles(new ArrayList());
                }
                if (rs.getString(2) != null && (role = WebUserRepositoryMock.this.roleRepository.findOne(rs.getString(2))) != null) {
                    webUser.getSecurityRoles().add(role);
                }
                return webUser;
            }
        });
        return webUser.getName() == null ? null : webUser;
    }

    @Override
    public long count() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM webUser;");
    }

    @Override
    public boolean exists(String paramID) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        List rows = this.jdbcTemplate.queryForList("SELECT id FROM webUser WHERE id=?;", String.class, new Object[]{paramID});
        return !rows.isEmpty();
    }

    @Override
    public void delete(String arg0) {
        String query = "DELETE FROM webUser where id=?;";
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.jdbcTemplate.update(query, new Object[]{arg0});
        query = "DELETE FROM webUserRoles where webUserId=?;";
        this.jdbcTemplate.update(query, new Object[]{arg0});
    }

    @Override
    public void delete(WebUser arg0) {
        this.delete(arg0.getName());
    }

    @Override
    public void deleteAll() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.jdbcTemplate.update("DELETE FROM webUser;");
    }

    @Override
    public Iterable<WebUser> findAll() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        String query = "SELECT w.id, w.password, wr.securityRoleId FROM webUser w LEFT JOIN webUserRoles wr ON w.id=wr.webUserId;";
        final HashMap users = new HashMap();
        this.jdbcTemplate.query(query, (RowMapper)new RowMapper<WebUser>(){

            public WebUser mapRow(ResultSet rs, int arg1) throws SQLException {
                SecurityRole role;
                WebUser webUser = null;
                if (users.containsKey(rs.getString(1))) {
                    webUser = (WebUser)users.get(rs.getString(1));
                } else {
                    webUser = new WebUser();
                    webUser.setName(rs.getString(1));
                    webUser.setPassword(rs.getString(2));
                    webUser.setSecurityRoles(new ArrayList());
                }
                if (rs.getString(3) != null && (role = WebUserRepositoryMock.this.roleRepository.findOne(rs.getString(3))) != null) {
                    webUser.getSecurityRoles().add(role);
                }
                users.put(rs.getString(1), webUser);
                return webUser;
            }
        });
        return new ArrayList<WebUser>(users.values());
    }

    @Override
    public WebUser findOne(String arg0) {
        return this.getUser(arg0);
    }

    @Override
    public <S extends WebUser> S save(final S arg0) {
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(this.dataSource));
        transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus arg) {
                WebUserRepositoryMock.this.delete(arg0);
                String query = "REPLACE INTO webUser (id, password) values (?, ?);";
                int updateResult = WebUserRepositoryMock.this.jdbcTemplate.update(query, new Object[]{arg0.getName(), arg0.getPassword()});
                if (updateResult == 1) {
                    query = "REPLACE INTO webUserRoles (webUserId, securityRoleId) values (?, ?);";
                    for (SecurityRole role : arg0.getSecurityRoles()) {
                        WebUserRepositoryMock.this.jdbcTemplate.update(query, new Object[]{arg0.getName(), role.getName()});
                    }
                }
                return null;
            }
        });
        return arg0;
    }

    @Override
    public <S extends WebUser> Iterable<S> save(Iterable<S> arg0) {
        for (WebUser object : arg0) {
            this.save(object);
        }
        return arg0;
    }

    public void setRoleRepository(SecurityRoleRepositoryMock roleRepository) {
        this.roleRepository = roleRepository;
    }

    public SecurityRoleRepositoryMock getRoleRepository() {
        return this.roleRepository;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

