/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashregistry.mock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import su.artix.cashregistry.mock.SecurityPermissionRepositoryMock;
import su.artix.cashregistry.mock.StubRepository;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.repository.SecurityRoleRepository;

public class SecurityRoleRepositoryMock
extends StubRepository<SecurityRole, String>
implements SecurityRoleRepository {
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private SecurityPermissionRepositoryMock permissionRepository;

    public SecurityRole findByName(String name) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        String query = "SELECT r.id, rp.securityPermissionId FROM securityRole r LEFT JOIN securityRolePermissions rp ON r.id=rp.securityRoleId WHERE r.id=?;";
        final SecurityRole securityRole = new SecurityRole();
        this.jdbcTemplate.query(query, new Object[]{name}, (RowMapper)new RowMapper<SecurityRole>(){

            public SecurityRole mapRow(ResultSet rs, int arg1) throws SQLException {
                if (securityRole.getName() == null) {
                    securityRole.setName(rs.getString(1));
                    securityRole.setPermissions(new ArrayList());
                }
                if (rs.getString(2) != null && securityRole.getRoleName().equals(rs.getString(1))) {
                    securityRole.getPermissions().add(SecurityRoleRepositoryMock.this.permissionRepository.findOne(rs.getInt(2)));
                }
                return securityRole;
            }
        });
        return securityRole;
    }

    @Override
    public List<SecurityRole> findAll() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        String query = "SELECT r.id, rp.securityPermissionId FROM securityRole r LEFT JOIN securityRolePermissions rp ON r.id=rp.securityRoleId;";
        final HashMap roles = new HashMap();
        this.jdbcTemplate.query(query, (RowMapper)new RowMapper<SecurityRole>(){

            public SecurityRole mapRow(ResultSet rs, int arg1) throws SQLException {
                SecurityRole securityRole = null;
                if (roles.containsKey(rs.getString(1))) {
                    securityRole = (SecurityRole)roles.get(rs.getString(1));
                } else {
                    securityRole = new SecurityRole(rs.getString(1));
                    securityRole.setPermissions(new ArrayList());
                }
                if (rs.getString(2) != null) {
                    securityRole.getPermissions().add(SecurityRoleRepositoryMock.this.permissionRepository.findOne(rs.getInt(2)));
                }
                roles.put(rs.getString(1), securityRole);
                return securityRole;
            }
        });
        return new ArrayList<SecurityRole>(roles.values());
    }

    @Override
    public long count() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM securityRole;");
    }

    @Override
    public boolean exists(String paramID) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        SecurityRole role = new SecurityRole(paramID);
        List rows = this.jdbcTemplate.queryForList("SELECT id FROM securityRole WHERE id=?;", String.class, new Object[]{role.getRoleName()});
        return !rows.isEmpty();
    }

    @Override
    public void delete(String arg0) {
        String id = new SecurityRole(arg0).getRoleName();
        String query = "DELETE FROM securityRole where id=?;";
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.jdbcTemplate.update(query, new Object[]{id});
        query = "DELETE FROM securityRolePermissions where securityRoleId=?;";
        this.jdbcTemplate.update(query, new Object[]{id});
    }

    @Override
    public void delete(SecurityRole arg0) {
        if (arg0 != null) {
            this.delete(arg0.getRoleName());
        }
    }

    @Override
    public void deleteAll() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.jdbcTemplate.update("DELETE FROM securityRole;");
    }

    @Override
    public SecurityRole findOne(String arg0) {
        return this.findByName(arg0);
    }

    @Override
    public <S extends SecurityRole> S save(final S arg0) {
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(this.dataSource));
        transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus arg) {
                SecurityRoleRepositoryMock.this.delete(arg0);
                String query = "REPLACE INTO securityRole (id) values (?);";
                int updateResult = SecurityRoleRepositoryMock.this.jdbcTemplate.update(query, new Object[]{arg0.getRoleName()});
                if (updateResult == 1) {
                    query = "REPLACE INTO securityRolePermissions (securityRoleId, securityPermissionId) values (?, ?);";
                    for (SecurityPermission permission : arg0.getPermissions()) {
                        SecurityRoleRepositoryMock.this.jdbcTemplate.update(query, new Object[]{arg0.getRoleName(), permission.getId()});
                    }
                }
                return null;
            }
        });
        return arg0;
    }

    @Override
    public <S extends SecurityRole> Iterable<S> save(Iterable<S> arg0) {
        for (SecurityRole object : arg0) {
            this.save(object);
        }
        return arg0;
    }

    public void setPermissionRepository(SecurityPermissionRepositoryMock permissionRepository) {
        this.permissionRepository = permissionRepository;
    }

    public SecurityPermissionRepositoryMock getPermissionRepository() {
        return this.permissionRepository;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

