/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter {
    static final List<Class<?>> TYPES = Arrays.asList(Pageable.class, Sort.class);
    private static final String PARAM_ON_SPECIAL = String.format("You must not user @%s on a parameter typed %s or %s", Param.class.getSimpleName(), Pageable.class.getSimpleName(), Sort.class.getSimpleName());
    private static final String NAMED_PARAMETER_TEMPLATE = ":%s";
    private static final String POSITION_PARAMETER_TEMPLATE = "?%s";
    private final MethodParameter parameter;

    protected Parameter(MethodParameter parameter) {
        Assert.notNull((Object)parameter);
        this.parameter = parameter;
        if (this.isSpecialParameter() && this.isNamedParameter()) {
            throw new IllegalArgumentException(PARAM_ON_SPECIAL);
        }
    }

    boolean isFirst() {
        return this.getIndex() == 0;
    }

    public boolean isSpecialParameter() {
        return TYPES.contains(this.parameter.getParameterType());
    }

    public boolean isBindable() {
        return !this.isSpecialParameter();
    }

    public String getPlaceholder() {
        if (this.isNamedParameter()) {
            return String.format(NAMED_PARAMETER_TEMPLATE, this.getName());
        }
        return String.format(POSITION_PARAMETER_TEMPLATE, this.getIndex());
    }

    public int getIndex() {
        return this.parameter.getParameterIndex();
    }

    public boolean isNamedParameter() {
        return !this.isSpecialParameter() && this.getName() != null;
    }

    public String getName() {
        Param annotation = (Param)this.parameter.getParameterAnnotation(Param.class);
        return annotation == null ? this.parameter.getParameterName() : annotation.value();
    }

    public Class<?> getType() {
        return this.parameter.getParameterType();
    }

    public String toString() {
        return String.format("%s:%s", this.isNamedParameter() ? this.getName() : "#" + this.getIndex(), this.getType().getName());
    }

    boolean isPageable() {
        return Pageable.class.isAssignableFrom(this.getType());
    }

    boolean isSort() {
        return Sort.class.isAssignableFrom(this.getType());
    }
}

