/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mysema.query.mongodb.MongodbQuery;
import com.mysema.query.types.EntityPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbQuery;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuerydslRepositorySupport {
    private final MongoOperations template;
    private final MappingContext<? extends MongoPersistentEntity<?>, ?> context;

    public QuerydslRepositorySupport(MongoOperations operations) {
        Assert.notNull((Object)operations);
        this.template = operations;
        this.context = operations.getConverter().getMappingContext();
    }

    protected <T> MongodbQuery<T> from(EntityPath<T> path) {
        Assert.notNull(path);
        MongoPersistentEntity entity = (MongoPersistentEntity)this.context.getPersistentEntity(path.getType());
        return this.from(path, entity.getCollection());
    }

    protected <T> MongodbQuery<T> from(EntityPath<T> path, String collection) {
        Assert.notNull(path);
        Assert.hasText((String)collection);
        return new SpringDataMongodbQuery(this.template, path.getType(), collection);
    }
}

