/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.core.cashregistry.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;
import su.artix.cashserver.core.cashregistry.domain.RightsUtil;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;

public class WebUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @NotNull
    private String name;
    @NotNull
    private String password;
    private String userRights = "";
    @Transient
    private RightsUtil rightsUtil = new RightsUtil();
    @DBRef(db="securityRole")
    private List<SecurityRole> securityRoles = new ArrayList<SecurityRole>();
    private String clusterId;
    private String mysqlLogin;
    private String mysqlPassword;
    private String basePrefix;
    private String deptCode;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserRights() {
        return this.userRights;
    }

    public void setUserRights(String userRights) {
        this.userRights = userRights;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebUserImpl [name=");
        builder.append(this.name);
        builder.append(", password=");
        builder.append("[PROTECTED]");
        builder.append(", userRights=");
        builder.append(this.userRights);
        builder.append("]");
        return builder.toString();
    }

    public boolean checkPassword(String password) {
        return this.password != null && this.password.equals(password);
    }

    public boolean hasRight(int right) {
        this.rightsUtil = new RightsUtil();
        return this.rightsUtil.hasRight(this.userRights, right);
    }

    public void setRight(int index, boolean on) {
        this.userRights = this.rightsUtil.setRight(this.userRights, index, on);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebUser other = (WebUser)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void setSecurityRoles(List<SecurityRole> securityRoles) {
        this.securityRoles = securityRoles;
    }

    public List<SecurityRole> getSecurityRoles() {
        return this.securityRoles;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getMysqlLogin() {
        return this.mysqlLogin;
    }

    public void setMysqlLogin(String mysqlLogin) {
        this.mysqlLogin = mysqlLogin;
    }

    public String getMysqlPassword() {
        return this.mysqlPassword;
    }

    public void setMysqlPassword(String mysqlPassword) {
        this.mysqlPassword = mysqlPassword;
    }

    public String getBasePrefix() {
        return this.basePrefix;
    }

    public void setBasePrefix(String basePrefix) {
        this.basePrefix = basePrefix;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }
}

