/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import su.artix.cashserver.security.SecurityKey;
import su.artix.loyaltylib.domain.java.discountsystem.PositionMark;
import su.artix.yuki.editors.EditorComposite;

@SecurityKey(title="\u0412\u043a\u043b\u0430\u0434\u043a\u0430 \u0441 \u0442\u0435\u043a\u0441\u0442\u043e\u043c \u0434\u043b\u044f \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0447\u0435\u043a\u0430")
public class DiscountPanelPositionMark
extends EditorComposite<PositionMark> {
    @SecurityKey(title="\u0422\u0435\u043a\u0441\u0442 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u0438", id="text")
    private Text cashText;
    @SecurityKey(title="\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430", id="textColor")
    private Label positionMarkTextColorLabel;
    @SecurityKey(id="textColor")
    private Text positionMarkTextColorText;
    @SecurityKey(id="textColor")
    private Button positionMarkTextColorButton;
    @SecurityKey(title="\u0426\u0432\u0435\u0442 \u0431\u0435\u0439\u0434\u0436\u0430", id="backgroundColor")
    private Label positionMarkBackgroundLabel;
    @SecurityKey(id="backgroundColor")
    private Text positionMarkBackgroundText;
    @SecurityKey(id="backgroundColor")
    private Button positionMarkBackgroundButton;

    public DiscountPanelPositionMark(Composite parent, int style, Class<PositionMark> clazz, PositionMark model) {
        super(parent, style, clazz, (Object)model);
    }

    public void initialize() {
        DiscountPanelPositionMark container = this;
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        this.cashText = new Text((Composite)container, 2882);
        GridDataFactory.fillDefaults().span(3, 1).hint(0, 100).align(4, 4).grab(true, true).applyTo((Control)this.cashText);
        this.positionMarkTextColorLabel = new Label((Composite)this, 0);
        this.positionMarkTextColorLabel.setText("\u0426\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430:");
        this.positionMarkTextColorText = new Text((Composite)this, 0);
        this.positionMarkTextColorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DiscountPanelPositionMark.this.positionMarkTextColorText.setBackground(DiscountPanelPositionMark.hexToColor((Device)DiscountPanelPositionMark.this.getDisplay(), DiscountPanelPositionMark.this.positionMarkTextColorText.getText()));
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.positionMarkTextColorText);
        this.positionMarkTextColorButton = new Button((Composite)this, 8);
        this.positionMarkTextColorButton.setText("...");
        this.positionMarkTextColorButton.addSelectionListener((SelectionListener)new ColorSelectionAdapter(this.positionMarkTextColorText));
        this.positionMarkBackgroundLabel = new Label((Composite)this, 0);
        this.positionMarkBackgroundLabel.setText("\u0426\u0432\u0435\u0442 \u0431\u0435\u0439\u0434\u0436\u0430:");
        this.positionMarkBackgroundText = new Text((Composite)this, 0);
        this.positionMarkBackgroundText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DiscountPanelPositionMark.this.positionMarkBackgroundText.setBackground(DiscountPanelPositionMark.hexToColor((Device)DiscountPanelPositionMark.this.getDisplay(), DiscountPanelPositionMark.this.positionMarkBackgroundText.getText()));
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.positionMarkBackgroundText);
        this.positionMarkBackgroundButton = new Button((Composite)this, 8);
        this.positionMarkBackgroundButton.setText("...");
        this.positionMarkBackgroundButton.addSelectionListener((SelectionListener)new ColorSelectionAdapter(this.positionMarkBackgroundText));
        this.bindValues();
    }

    public static Color hexToColor(Device device, String hexColor) {
        if (device == null || hexColor == null || !hexColor.startsWith("#")) {
            return null;
        }
        String trimmed = hexColor.substring(1);
        if (trimmed.length() != 6) {
            return null;
        }
        try {
            int r = Integer.parseInt(trimmed.substring(0, 2), 16);
            int g = Integer.parseInt(trimmed.substring(2, 4), 16);
            int b = Integer.parseInt(trimmed.substring(4, 6), 16);
            return new Color(device, r, g, b);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void bindValues() {
        this.initDefaulBinding();
    }

    private class ColorSelectionAdapter
    extends SelectionAdapter {
        public Text textColor;

        public ColorSelectionAdapter(Text textColor) {
            this.textColor = textColor;
        }

        public void widgetSelected(SelectionEvent e) {
            ColorDialog cd = new ColorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            cd.setText("\u0426\u0432\u0435\u0442");
            cd.setRGB(new RGB(255, 255, 255));
            RGB newColor = cd.open();
            if (newColor == null) {
                return;
            }
            String hex = String.format("#%02x%02x%02x", newColor.red, newColor.green, newColor.blue);
            this.textColor.setText(hex);
        }
    }
}

