/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.generator.GeneratorUtils;
import org.dozer.classmap.generator.JavaBeanFieldsDetector;
import org.dozer.util.CollectionUtils;

public class BeanMappingGenerator
implements ClassMapBuilder.ClassMappingGenerator {
    static final List<BeanFieldsDetector> pluggedFieldDetectors = new ArrayList<BeanFieldsDetector>();
    static final List<BeanFieldsDetector> availableFieldDetectors = new ArrayList<BeanFieldsDetector>(){
        {
            this.add(new JavaBeanFieldsDetector());
        }
    };

    @Override
    public boolean accepts(ClassMap classMap) {
        return true;
    }

    @Override
    public boolean apply(ClassMap classMap, Configuration configuration) {
        Class<?> srcClass = classMap.getSrcClassToMap();
        Class<?> destClass = classMap.getDestClassToMap();
        Set<String> destFieldNames = BeanMappingGenerator.getAcceptsFieldsDetector(destClass).getWritableFieldNames(destClass);
        Set<String> srcFieldNames = BeanMappingGenerator.getAcceptsFieldsDetector(srcClass).getReadableFieldNames(srcClass);
        Set<String> commonFieldNames = CollectionUtils.intersection(srcFieldNames, destFieldNames);
        for (String fieldName : commonFieldNames) {
            if (GeneratorUtils.shouldIgnoreField(fieldName, srcClass, destClass) || classMap.getFieldMapUsingDest(fieldName) != null || classMap.getFieldMapUsingSrc(fieldName) != null) continue;
            GeneratorUtils.addGenericMapping(classMap, configuration, fieldName, fieldName);
        }
        return false;
    }

    private static BeanFieldsDetector getAcceptsFieldsDetector(Class<?> clazz) {
        BeanFieldsDetector detector = BeanMappingGenerator.getAcceptsFieldDetector(clazz, pluggedFieldDetectors);
        if (detector == null) {
            detector = BeanMappingGenerator.getAcceptsFieldDetector(clazz, availableFieldDetectors);
        }
        return detector;
    }

    private static BeanFieldsDetector getAcceptsFieldDetector(Class<?> clazz, List<BeanFieldsDetector> detectors) {
        for (BeanFieldsDetector detector : new CopyOnWriteArrayList<BeanFieldsDetector>(detectors)) {
            if (!detector.accepts(clazz)) continue;
            return detector;
        }
        return null;
    }

    public static void addPluggedFieldDetector(BeanFieldsDetector protobufBeanFieldsDetector) {
        pluggedFieldDetectors.add(protobufBeanFieldsDetector);
    }

    protected static interface BeanFieldsDetector {
        public boolean accepts(Class<?> var1);

        public Set<String> getReadableFieldNames(Class<?> var1);

        public Set<String> getWritableFieldNames(Class<?> var1);
    }
}

