/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.roundedToolbar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.roundedToolbar.RoundedToolItem;
import org.mihalis.opal.utils.AdvancedPath;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class RoundedToolbar
extends Canvas {
    private final List<RoundedToolItem> items;
    private boolean multiSelection;
    private int cornerRadius = 2;
    private static Color START_GRADIENT_COLOR_DEFAULT = SWTGraphicUtil.getColorSafely(245, 245, 245);
    private static Color END_GRADIENT_COLOR_DEFAULT = SWTGraphicUtil.getColorSafely(185, 185, 185);
    static Color BORDER_COLOR = SWTGraphicUtil.getColorSafely(66, 66, 66);
    private Color START_GRADIENT_COLOR = START_GRADIENT_COLOR_DEFAULT;
    private Color END_GRADIENT_COLOR = END_GRADIENT_COLOR_DEFAULT;

    public RoundedToolbar(Composite composite, int n) {
        super(composite, n | 0x20000000);
        this.items = new ArrayList<RoundedToolItem>();
        this.addListeners();
    }

    public RoundedToolbar(Composite composite, int n, Color color, Color color2) {
        super(composite, n | 0x20000000);
        this.items = new ArrayList<RoundedToolItem>();
        this.addListeners();
        this.START_GRADIENT_COLOR = color;
        this.END_GRADIENT_COLOR = color2;
    }

    private void addListeners() {
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                for (RoundedToolItem roundedToolItem : RoundedToolbar.this.items) {
                    if (!roundedToolItem.getBounds().contains(event.x, event.y)) continue;
                    if (!RoundedToolbar.this.multiSelection) {
                        this.applyRadioBehaviour(roundedToolItem);
                    }
                    roundedToolItem.setSelection(!roundedToolItem.getSelection());
                    roundedToolItem.fireSelectionEvent();
                    RoundedToolbar.this.redraw();
                    RoundedToolbar.this.update();
                    return;
                }
            }

            private void applyRadioBehaviour(RoundedToolItem roundedToolItem) {
                for (RoundedToolItem roundedToolItem2 : RoundedToolbar.this.items) {
                    if (((Object)((Object)roundedToolItem2)).equals((Object)roundedToolItem)) continue;
                    roundedToolItem2.setSelection(false);
                    roundedToolItem2.fireSelectionEvent();
                }
            }
        });
        this.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                for (RoundedToolItem roundedToolItem : RoundedToolbar.this.items) {
                    if (!roundedToolItem.getBounds().contains(event.x, event.y)) continue;
                    RoundedToolbar.this.setToolTipText(roundedToolItem.getTooltipText() == null ? "" : roundedToolItem.getTooltipText());
                    return;
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                RoundedToolbar.this.paintControl(paintEvent);
            }
        });
    }

    void addItem(RoundedToolItem roundedToolItem) {
        this.items.add(roundedToolItem);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        for (RoundedToolItem roundedToolItem : this.items) {
            n3 += roundedToolItem.getWidth();
            n4 = Math.max(n4, roundedToolItem.getHeight());
        }
        return new Point(Math.max(n3, n), Math.max(n4, n2));
    }

    public int getCornerRadius() {
        this.checkWidget();
        return this.cornerRadius;
    }

    public RoundedToolItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n > this.items.size()) {
            SWT.error((int)5);
        }
        return this.items.get(n);
    }

    public RoundedToolItem getItem(Point point) {
        this.checkWidget();
        for (RoundedToolItem roundedToolItem : this.items) {
            if (!roundedToolItem.getBounds().contains(point)) continue;
            return roundedToolItem;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public RoundedToolItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new RoundedToolItem[this.items.size()]);
    }

    public int indexOf(RoundedToolItem roundedToolItem) {
        this.checkWidget();
        return this.items.indexOf((Object)roundedToolItem);
    }

    public boolean isMultiselection() {
        this.checkWidget();
        return this.multiSelection;
    }

    protected void paintControl(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        gC.setAdvanced(true);
        gC.setAntialias(1);
        int n = this.getSize().x;
        int n2 = this.getSize().y;
        this.drawBorders(gC, n, n2);
        Iterator<RoundedToolItem> iterator = this.items.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            RoundedToolItem roundedToolItem = iterator.next();
            roundedToolItem.drawButton(gC, n3, n2, !iterator.hasNext());
            n3 += roundedToolItem.getWidth();
        }
    }

    private void drawBorders(GC gC, int n, int n2) {
        AdvancedPath advancedPath = new AdvancedPath((Device)this.getDisplay());
        advancedPath.addRoundRectangle(0.0f, 0.0f, n, n2, this.cornerRadius, this.cornerRadius);
        gC.setClipping((Path)advancedPath);
        gC.setForeground(this.START_GRADIENT_COLOR);
        gC.setBackground(this.END_GRADIENT_COLOR);
        gC.fillGradientRectangle(0, 0, n, n2, true);
        gC.setForeground(BORDER_COLOR);
        gC.drawRoundRectangle(0, 0, n - 1, n2 - 1, this.cornerRadius, this.cornerRadius);
        gC.setClipping((Rectangle)null);
    }

    void removeItem(RoundedToolItem roundedToolItem) {
        this.checkWidget();
        this.items.remove((Object)roundedToolItem);
    }

    public void setCornerRadius(int n) {
        this.checkWidget();
        this.cornerRadius = n;
    }

    public void setMultiselection(boolean bl) {
        this.checkWidget();
        this.multiSelection = bl;
    }
}

