/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.launcher;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.utils.SWTGraphicUtil;

class LauncherLabel
extends Canvas {
    private String text;
    private Image image;
    private Font font;
    private static final int GAP = 12;
    private static int DRAW_FLAGS = 15;
    private static final int DEFAULT_MARGIN = 5;
    private int leftMargin = 5;
    private int topMargin = 5;
    private int rightMargin = 5;
    private int bottomMargin = 5;
    private Point textSize;
    private static final int MAX_NUMBER_OF_STEPS = 10;
    private int animationStep = 0;

    LauncherLabel(Composite composite, int n) {
        super(composite, n | 0x800 | 0x20000000);
        Font font;
        Font font2 = super.getFont();
        this.font = font = new Font((Device)this.getDisplay(), font2.getFontData()[0].getName(), 18, 1);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)font);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                LauncherLabel.this.onPaint(paintEvent);
            }
        });
    }

    private void onPaint(PaintEvent paintEvent) {
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Image image = new Image((Device)this.getDisplay(), Math.max(1, rectangle.width), Math.max(1, rectangle.height));
        GC gC = new GC((Drawable)image);
        gC.setForeground(this.getForeground());
        gC.setBackground(this.getBackground());
        gC.fillRectangle(rectangle);
        Point point = this.getTotalSize(this.image.getBounds().width, this.image.getBounds().height);
        int n = (rectangle.width - this.image.getBounds().width) / 2;
        int n2 = (rectangle.height - point.y) / 2;
        gC.drawImage(this.image, n, n2);
        gC.setFont(this.font);
        int n3 = (rectangle.width - this.textSize.x) / 2;
        int n4 = n2 + this.image.getBounds().height + 12 - this.textSize.y / 2;
        gC.drawString(this.text, n3, n4);
        if (this.animationStep != 0) {
            float f = 1.0f + (float)(this.animationStep * (Math.max(point.x, point.y) - Math.max(this.image.getBounds().width, this.image.getBounds().height)) / 10) / 100.0f;
            int n5 = (int)((float)this.image.getBounds().width * f);
            int n6 = (int)((float)this.image.getBounds().height * f);
            gC.setAntialias(1);
            gC.setInterpolation(2);
            gC.setAlpha(255 - 25 * this.animationStep);
            Point point2 = this.getTotalSize(n5, n6);
            int n7 = (rectangle.width - n5) / 2;
            int n8 = (rectangle.height - point2.y) / 2;
            gC.drawImage(this.image, 0, 0, this.image.getBounds().width, this.image.getBounds().height, n7, n8, (int)((float)this.image.getBounds().width * f), (int)((float)this.image.getBounds().height * f));
        }
        gC.dispose();
        paintEvent.gc.drawImage(image, 0, 0);
        image.dispose();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = this.getTotalSize(this.image.getBounds().width, this.image.getBounds().height);
        point.x = n == -1 ? (point.x += this.leftMargin + this.rightMargin) : n;
        point.y = n2 == -1 ? (point.y += this.topMargin + this.bottomMargin) : n2;
        return point;
    }

    private Point getTotalSize(int n, int n2) {
        Point point = new Point(0, 0);
        int n3 = 0;
        int n4 = 0;
        if (this.textSize == null) {
            GC gC = new GC((Drawable)this);
            gC.setFont(this.font);
            this.textSize = gC.textExtent(this.text, DRAW_FLAGS);
            gC.dispose();
        }
        n3 = this.textSize.x;
        n4 = this.textSize.y;
        point.x = Math.max(n, n3);
        point.y = n2 + 12 + n4;
        return point;
    }

    String getText() {
        return this.text;
    }

    void setText(String string) {
        this.text = string;
    }

    Image getImage() {
        return this.image;
    }

    void setImage(Image image) {
        this.image = image;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    boolean incrementAnimation() {
        boolean bl;
        ++this.animationStep;
        boolean bl2 = bl = this.animationStep > 10;
        if (bl) {
            this.animationStep = 0;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
        return !bl;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int n) {
        this.leftMargin = n;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int n) {
        this.topMargin = n;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int n) {
        this.rightMargin = n;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int n) {
        this.bottomMargin = n;
    }
}

