/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.convertor.discountsystem;

import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PythonInterpreterFactory {
    private static final Logger log = LoggerFactory.getLogger(PythonInterpreterFactory.class);
    private static Set<String> bundleLocations = new ConcurrentSkipListSet<String>();
    private static final Queue<PythonInterpreter> interpreters = new LinkedBlockingQueue<PythonInterpreter>();

    private PythonInterpreterFactory() {
    }

    public static void clearInterpreters() {
        interpreters.clear();
    }

    public static PythonInterpreter resolveInterpreter() {
        PythonInterpreter interpreter = interpreters.poll();
        if (interpreter == null) {
            interpreter = PythonInterpreterFactory.createNewInterpreter();
        }
        log.info("Using Python interpreter: {}", (Object)interpreter);
        return interpreter;
    }

    private static PythonInterpreter createNewInterpreter() {
        long startTime = System.currentTimeMillis();
        PySystemState systemState = Py.getSystemState();
        for (String location : bundleLocations) {
            systemState.path.append((PyObject)new PyString(location));
        }
        systemState.setdefaultencoding("utf-8");
        PythonInterpreter interpreter = new PythonInterpreter(null, systemState);
        try {
            interpreter.exec("import sys");
            interpreter.exec("print(sys.path)");
            interpreter.exec("import yaml");
            interpreter.exec("import artixds.domain");
        }
        catch (Exception e) {
            log.error("Failed to initialize Python interpreter", (Throwable)e);
            throw new RuntimeException("Python interpreter init failed", e);
        }
        log.info("Python interpreter created in {} ms", (Object)(System.currentTimeMillis() - startTime));
        return interpreter;
    }

    public static void addBundleLocations(List<String> bundleLocations) {
        PythonInterpreterFactory.bundleLocations.addAll(bundleLocations);
    }

    public static void releaseInterpreter(PythonInterpreter interpreter) {
        log.info("Releasing Python interpreter: {}", (Object)interpreter);
        if (interpreter != null) {
            interpreters.offer(interpreter);
        }
    }

    static {
        Properties postProperties = new Properties();
        postProperties.setProperty("python.cachedir", "../cachedir");
        PythonInterpreter.initialize((Properties)System.getProperties(), (Properties)postProperties, null);
    }
}

