/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.directory;

import java.util.Collection;
import java.util.List;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.domain.TmcKit;
import ru.ssa.cashadmin.domain.TmcKitItem;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.model.directory.DirectoryModel;
import su.artix.yuki.model.directory.DirectoryModelFactory;

public class DirectoryTmcKitModel
extends DirectoryModel<TmcKit> {
    public DirectoryTmcKitModel() {
        super(TmcKit.class);
    }

    @Override
    protected void doAfterChangeId(Object oldId, TmcKit obj) throws ExecuteQueryException {
        String id = (String)oldId;
        this.updateTmcKitItems(id, obj);
    }

    @Override
    public void delete(TmcKit obj) throws ExecuteQueryException {
        super.delete(obj);
        this.removeTmcKitItems(obj);
    }

    @Override
    public void cascadeRefresh() {
        super.cascadeRefresh();
        DirectoryModelFactory.getModel(TmcKitItem.class).firePropertyChange(DirectoryAction.CASCADE_REFRESH, null, null);
    }

    private void updateTmcKitItems(String oldId, TmcKit obj) throws ExecuteQueryException {
        TmcKitItem state = (TmcKitItem)LibActivator.getDefault().getActualClassResolver().getInstance(TmcKitItem.class);
        state.setTmcKitBarcode(oldId);
        state.getPk().setTmcKitBarcode(oldId);
        DaoInterface dao = DaoFactory.getDAO(TmcKitItem.class);
        List list = dao.getList((Object)state);
        dao.deleteAll((Collection)list);
        for (TmcKitItem command : list) {
            command.setTmcKit(obj);
            dao.update((Object)command);
        }
    }

    private void removeTmcKitItems(TmcKit obj) throws ExecuteQueryException {
        TmcKitItem state = (TmcKitItem)LibActivator.getDefault().getActualClassResolver().getInstance(TmcKitItem.class);
        state.setTmcKitBarcode(obj.getBarcode());
        state.getPk().setTmcKitBarcode(obj.getBarcode());
        DaoInterface dao = DaoFactory.getDAO(TmcKitItem.class);
        dao.deleteAll((Collection)dao.getList((Object)state));
    }
}

