/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashregistry.mock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import su.artix.cashregistry.mock.SecurityObjectRepositoryMock;
import su.artix.cashregistry.mock.StubRepository;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;
import su.artix.cashserver.core.cashregistry.repository.SecurityPermissionRepository;

public class SecurityPermissionRepositoryMock
extends StubRepository<SecurityPermission, Integer>
implements SecurityPermissionRepository {
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private SecurityObjectRepositoryMock objectRepository;

    @Override
    public List<SecurityPermission> findAll() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return this.jdbcTemplate.query("SELECT permission, securityObjectId FROM securityPermission;", (RowMapper)new RowMapper<SecurityPermission>(){

            public SecurityPermission mapRow(ResultSet rs, int arg1) throws SQLException {
                SecurityPermission permission = new SecurityPermission(SecurityPermissionRepositoryMock.this.objectRepository.findById(rs.getString(2)), Integer.valueOf(rs.getInt(1)));
                return permission;
            }
        });
    }

    public SecurityPermission findById(Integer id) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return (SecurityPermission)this.jdbcTemplate.query("SELECT permission, securityObjectId FROM securityPermission WHERE id=?;", new Object[]{id}, (ResultSetExtractor)new ResultSetExtractor<SecurityPermission>(){

            public SecurityPermission extractData(ResultSet rs) throws SQLException {
                return new SecurityPermission(SecurityPermissionRepositoryMock.this.objectRepository.findById(rs.getString(2)), Integer.valueOf(rs.getInt(1)));
            }
        });
    }

    @Override
    public long count() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM securityPermission;");
    }

    @Override
    public void delete(Integer arg0) {
        String query = "DELETE FROM securityPermission where id=?;";
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.jdbcTemplate.update(query, new Object[]{arg0});
    }

    @Override
    public void delete(SecurityPermission arg0) {
        if (arg0 != null) {
            this.delete(arg0.getId());
        }
    }

    @Override
    public void deleteAll() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.jdbcTemplate.update("DELETE FROM securityPermission;");
    }

    @Override
    public SecurityPermission findOne(Integer arg0) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return (SecurityPermission)this.jdbcTemplate.query("SELECT permission, securityObjectId FROM securityPermission WHERE id=?;", new Object[]{arg0}, (ResultSetExtractor)new ResultSetExtractor<SecurityPermission>(){

            public SecurityPermission extractData(ResultSet rs) throws SQLException {
                return new SecurityPermission(SecurityPermissionRepositoryMock.this.objectRepository.findById(rs.getString(2)), Integer.valueOf(rs.getInt(1)));
            }
        });
    }

    @Override
    public <S extends SecurityPermission> S save(S arg0) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        String query = "REPLACE INTO securityPermission (id, permission, securityObjectId) values (?, ?, ?);";
        this.jdbcTemplate.update(query, new Object[]{arg0.getId(), arg0.getPermission(), arg0.getSecurityObject() == null ? null : arg0.getSecurityObject().getId()});
        return arg0;
    }

    @Override
    public <S extends SecurityPermission> Iterable<S> save(final Iterable<S> arg0) {
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(this.dataSource));
        transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus arg) {
                for (SecurityPermission object : arg0) {
                    SecurityPermissionRepositoryMock.this.save(object);
                }
                return null;
            }
        });
        return arg0;
    }

    public void setObjectRepository(SecurityObjectRepositoryMock objectRepository) {
        this.objectRepository = objectRepository;
    }

    public SecurityObjectRepositoryMock getObjectRepository() {
        return this.objectRepository;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

