/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.dao;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import ru.ssa.cashadmin.dao.DaoFactory;

public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);

    private SessionManager() {
    }

    public static void openSession(Class<?> cl) {
        log.trace("open");
        SessionFactory sessionFactory = DaoFactory.findAppropriateSessionFactory(cl);
        if (sessionFactory != null) {
            boolean existingTransaction;
            Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
            boolean bl = existingTransaction = sessionHolder != null && sessionHolder.containsSession(session);
            if (existingTransaction) {
                log.debug("Found thread-bound Session for HibernateInterceptor");
            } else if (sessionHolder != null) {
                sessionHolder.addSession(session);
            } else {
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder(session));
            }
        }
    }

    public static void closeSession(Class<?> cl) {
        SessionHolder holder;
        log.trace("close");
        SessionFactory sessionFactory = DaoFactory.findAppropriateSessionFactory(cl);
        if (sessionFactory != null && (holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory)) != null && holder.getSession() != null) {
            Session s = holder.getSession();
            s.flush();
            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            SessionFactoryUtils.closeSession((Session)s);
            log.trace("real close");
        }
    }

    public static void flushSession(Class<?> cl) {
        SessionHolder holder;
        log.trace("close");
        SessionFactory sessionFactory = DaoFactory.findAppropriateSessionFactory(cl);
        if (sessionFactory != null && (holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory)) != null && holder.getSession() != null) {
            Session s = holder.getSession();
            s.flush();
            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            log.trace("flush ");
        }
    }
}

