/*
 * Decompiled with CFR 0.152.
 */
package cashserver.cashregistry.rest.repository;

import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.core.cashregistry.repository.WebUserRepository;
import su.artix.cashserver.rest.client.IClientGetter;

public class WebUserRepositoryRest
implements WebUserRepository {
    private IClientGetter clientGetter;

    public <S extends WebUser> S save(S webUser) {
        if (this.exists(webUser.getName())) {
            this.clientGetter.getClient().getWebUserEntity().updateWebUser(webUser.getName(), webUser);
        } else {
            this.clientGetter.getClient().getWebUserEntity().addWebUser(webUser);
        }
        return webUser;
    }

    public <S extends WebUser> Iterable<S> save(Iterable<S> entities) {
        for (WebUser webUser : entities) {
            this.save(webUser);
        }
        return entities;
    }

    public WebUser findOne(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return this.clientGetter.getClient().getWebUserEntity().getWebUser(id);
    }

    public boolean exists(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        return this.clientGetter.getClient().getWebUserEntity().existsWebUser(id);
    }

    public Iterable<WebUser> findAll() {
        return this.clientGetter.getClient().getWebUserEntity().getWebUsers();
    }

    public long count() {
        return this.clientGetter.getClient().getWebUserEntity().countWebUsers();
    }

    public void delete(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            this.clientGetter.getClient().getWebUserEntity().removeWebUser(id);
        }
    }

    public void delete(WebUser entity) {
        this.delete(entity.getName());
    }

    public void delete(Iterable<? extends WebUser> entities) {
        for (WebUser webUser : entities) {
            this.delete(webUser.getName());
        }
    }

    public WebUser findByNameAndPassword(String name, String password) {
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)password)) {
            return null;
        }
        return this.clientGetter.getClient().getWebUserEntity().getWebUser(name, password);
    }

    public Iterable<WebUser> findAll(Sort sort) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Page<WebUser> findAll(Pageable pageable) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterable<WebUser> findAll(Iterable<String> ids) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void deleteAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IClientGetter getClientGetter() {
        return this.clientGetter;
    }

    public void setClientGetter(IClientGetter clientGetter) {
        this.clientGetter = clientGetter;
    }
}

