/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.convertor.discountsystem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.python.core.PyDictionary;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.loyaltylib.convertor.discountsystem.JavaPythonProxy;
import su.artix.loyaltylib.convertor.discountsystem.PythonInterpreterFactory;
import su.artix.loyaltylib.domain.java.discountsystem.Counter;
import su.artix.loyaltylib.domain.java.discountsystem.Coupon;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCardCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountConditionTemplate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountConditionTemplateValue;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCouponCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountKitObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountKitObjectItem;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectCheck;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKitItem;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectPosition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateCalculate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateIndex;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitItem;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitObjectItem;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRatePercent;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRatePrice;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateSum;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.loyaltylib.domain.java.discountsystem.Gift;
import su.artix.loyaltylib.domain.java.discountsystem.LegacyObject;
import su.artix.loyaltylib.domain.java.discountsystem.Report;
import su.artix.loyaltylib.domain.java.discountsystem.SimpleObject;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.loyaltylib.domain.java.observable.Named;

public class DiscountSystemFromYaml {
    private static final Logger log = LoggerFactory.getLogger(DiscountSystemFromYaml.class);

    private static Discount createDiscount(PyObject pyDiscount) {
        PythonInterpreter interpreter = PythonInterpreterFactory.resolveInterpreter();
        interpreter.set("discount", pyDiscount);
        interpreter.exec("convertedDiscount = discount.convert()");
        PyObject pyConvertedDiscount = interpreter.get("convertedDiscount");
        JavaPythonProxy proxyDiscount = new JavaPythonProxy(pyConvertedDiscount);
        Discount discount = new Discount(proxyDiscount.getString("name"));
        discount.setId(Long.valueOf(proxyDiscount.getString("id")));
        Iterator<PyObject> discountObjects = proxyDiscount.getIterable("objects");
        while (discountObjects.hasNext()) {
            PyObject object = discountObjects.next();
            DiscountObject discountObject = DiscountSystemFromYaml.createDiscountObject(object);
            if (discountObject == null) {
                return null;
            }
            discount.addDiscountObject(discountObject);
        }
        discount.setDiscountRate(DiscountSystemFromYaml.createDiscountRate(discount, pyDiscount, proxyDiscount.getObject("discountRate")));
        Iterator<PyObject> discountConditions = proxyDiscount.getIterable("conditions");
        while (discountConditions.hasNext()) {
            PyObject condition = discountConditions.next();
            discount.addDiscountCondition(DiscountSystemFromYaml.createDiscountCondition(condition));
        }
        discount.setClientText(proxyDiscount.getString("clientText"));
        discount.setClientDisplayText(proxyDiscount.getString("clientDisplayText"));
        discount.setCashText(proxyDiscount.getString("cashText"));
        PyObject showCashTextToConsultant = proxyDiscount.getObject("showCashTextToConsultant");
        discount.setShowCashTextToConsultant(Boolean.valueOf(showCashTextToConsultant.toString()));
        PyObject minPriceIgnored = proxyDiscount.getObject("minPriceIgnored");
        discount.setMinPriceIgnored(Boolean.valueOf(minPriceIgnored.toString()));
        String active = proxyDiscount.getString("active");
        discount.setActive(Boolean.valueOf(active == null || Boolean.parseBoolean(active)));
        Iterator<PyObject> reports = proxyDiscount.getIterable("reports");
        while (reports.hasNext()) {
            PyObject report = reports.next();
            discount.addReport(DiscountSystemFromYaml.createReport(report));
        }
        Iterator<PyObject> coupons = proxyDiscount.getIterable("coupons");
        while (coupons.hasNext()) {
            PyObject coupon = coupons.next();
            discount.addCoupon(DiscountSystemFromYaml.createCoupon(coupon));
        }
        Iterator<PyObject> counters = proxyDiscount.getIterable("counters");
        while (counters.hasNext()) {
            PyObject counter = counters.next();
            discount.addCounter(DiscountSystemFromYaml.createCounter(counter, discount));
        }
        Iterator<PyObject> gifts = proxyDiscount.getIterable("gifts");
        while (gifts.hasNext()) {
            PyObject gift = gifts.next();
            discount.addGift(DiscountSystemFromYaml.createGift(gift));
        }
        PythonInterpreterFactory.releaseInterpreter(interpreter);
        return discount;
    }

    private static DiscountCondition createDiscountCondition(PyObject pyCondition) {
        String description;
        PythonInterpreter interpreter = PythonInterpreterFactory.resolveInterpreter();
        interpreter.set("condition", pyCondition);
        interpreter.exec("convertedCondition = condition.convert()");
        PyObject pyConvertedCondition = interpreter.get("convertedCondition");
        DiscountCardCondition discountCondition = null;
        String pyType = pyCondition.getType().getName();
        String condition = new JavaPythonProxy(pyConvertedCondition).getString("condition");
        try {
            description = new JavaPythonProxy(pyConvertedCondition).getString("description");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            description = "";
        }
        if (pyType.equalsIgnoreCase("DiscountCardCondition")) {
            discountCondition = new DiscountCardCondition(condition);
            discountCondition.setDescription(description);
        } else if (pyType.equalsIgnoreCase("DiscountCouponCondition")) {
            discountCondition = new DiscountCouponCondition(condition);
            discountCondition.setDescription(description);
        } else {
            discountCondition = new DiscountCondition(condition, description);
        }
        try {
            String specification = new JavaPythonProxy(pyConvertedCondition).getString("specification");
            String definition = new JavaPythonProxy(pyConvertedCondition).getString("definition");
            if (specification != null && definition != null) {
                DiscountConditionTemplate template = new DiscountConditionTemplate();
                template.setSpecification(specification);
                template.setDefinition(definition);
                Iterator<PyObject> iter = new JavaPythonProxy(pyConvertedCondition).getIterable("templateValues");
                while (iter.hasNext()) {
                    PyDictionary pyObject = (PyDictionary)iter.next();
                    String label = (String)pyObject.get((Object)"label");
                    String type = (String)pyObject.get((Object)"type");
                    String defaultValue = (String)pyObject.get((Object)"defaultValue");
                    DiscountConditionTemplateValue value = new DiscountConditionTemplateValue(label, type, defaultValue);
                    template.addValues(value);
                }
                discountCondition.setTemplate(template);
            } else {
                log.debug("No specification and definition found in Condition: {}", (Object)condition);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        PythonInterpreterFactory.releaseInterpreter(interpreter);
        return discountCondition;
    }

    private static DiscountObject createDiscountObject(PyObject object) {
        PythonInterpreter interpreter = PythonInterpreterFactory.resolveInterpreter();
        interpreter.set("object", object);
        interpreter.exec("convertedObject = object.convert()");
        PyObject pyConvertedObject = interpreter.get("convertedObject");
        DiscountObjectPosition discountObject = null;
        JavaPythonProxy proxyDiscountObject = new JavaPythonProxy(pyConvertedObject);
        if (object.getType().getName().equalsIgnoreCase("PositionObject")) {
            discountObject = new DiscountObjectPosition();
        } else if (object.getType().getName().equalsIgnoreCase("CheckObject")) {
            discountObject = new DiscountObjectCheck();
        } else if (object.getType().getName().equalsIgnoreCase("Kit")) {
            DiscountObjectKit kit = new DiscountObjectKit();
            kit.setName(proxyDiscountObject.getString("name"));
            String maxtimes = proxyDiscountObject.getString("maxtimes");
            if (maxtimes == null || maxtimes.equals("None")) {
                kit.setMaxTimesNotSpecified(true);
            } else {
                kit.setMaxTimesNotSpecified(false);
                kit.setMaxtimes(Integer.valueOf(Integer.parseInt(proxyDiscountObject.getString("maxtimes"))));
            }
            kit.setKittype(proxyDiscountObject.getString("kittype"));
            Iterator<PyObject> items = proxyDiscountObject.getIterable("items");
            while (items.hasNext()) {
                PyObject item = items.next();
                DiscountObjectKitItem discountObjectKitItem = DiscountSystemFromYaml.createDiscountObjectKitItem(item);
                kit.getListKitItems().add(discountObjectKitItem);
            }
            discountObject = kit;
        } else if (object.getType().getName().equalsIgnoreCase("KitObject")) {
            DiscountKitObject kit = new DiscountKitObject();
            kit.setName(proxyDiscountObject.getString("name"));
            String maxtimes = proxyDiscountObject.getString("maxtimes");
            if (maxtimes == null || maxtimes.equals("None")) {
                kit.setMaxTimesNotSpecified(true);
            } else {
                kit.setMaxTimesNotSpecified(false);
                kit.setMaxtimes(proxyDiscountObject.getString("maxtimes"));
            }
            PyObject byTmc = proxyDiscountObject.getObject("byTmc");
            kit.setByTmc(Boolean.valueOf(byTmc.toString()).booleanValue());
            PyObject cartesian = proxyDiscountObject.getObject("cartesian");
            kit.setCartesian(Boolean.valueOf(cartesian.toString()).booleanValue());
            PyObject distributeByCheck = proxyDiscountObject.getObject("distributeByCheck");
            kit.setDistributeByCheck(Boolean.valueOf(distributeByCheck.toString()).booleanValue());
            Iterator<PyObject> items = proxyDiscountObject.getIterable("items");
            while (items.hasNext()) {
                PyObject item = items.next();
                DiscountKitObjectItem discountObjectKitItem = DiscountSystemFromYaml.createDiscountKitObjectItem(item);
                kit.getListKitItems().add(discountObjectKitItem);
            }
            discountObject = kit;
        } else if (object.getType().getName().equalsIgnoreCase("LegacyObject")) {
            discountObject = new LegacyObject();
        } else if (object.getType().getName().equalsIgnoreCase("SimpleObject")) {
            discountObject = new SimpleObject();
        }
        PythonInterpreterFactory.releaseInterpreter(interpreter);
        return discountObject;
    }

    private static DiscountObjectKitItem createDiscountObjectKitItem(PyObject pyKitItem) {
        DiscountObjectKitItem discountObjectKitItem = new DiscountObjectKitItem();
        JavaPythonProxy itemProxy = new JavaPythonProxy(pyKitItem);
        discountObjectKitItem.setName(itemProxy.getString("name"));
        discountObjectKitItem.getGoodsCode().addAll((PyList)itemProxy.getObject("codes"));
        discountObjectKitItem.getExtendedOptions().addAll((PyList)itemProxy.getObject("extendedOptions"));
        discountObjectKitItem.getInventGroups().addAll((PyList)itemProxy.getObject("inventGroups"));
        discountObjectKitItem.setGoodsCount(Double.valueOf(itemProxy.getString("quantity")));
        return discountObjectKitItem;
    }

    private static DiscountKitObjectItem createDiscountKitObjectItem(PyObject pyKitItem) {
        DiscountKitObjectItem discountKitObjectItem = new DiscountKitObjectItem();
        JavaPythonProxy itemProxy = new JavaPythonProxy(pyKitItem);
        discountKitObjectItem.setName(itemProxy.getString("name"));
        discountKitObjectItem.getGoodsCode().addAll((PyList)itemProxy.getObject("catalogCodes"));
        discountKitObjectItem.setGoodsCount(Double.valueOf(itemProxy.getString("quantity")));
        return discountKitObjectItem;
    }

    private static DiscountObjectKitItem findDiscountObjectKitItem(Discount discount, PyObject pyDiscount, PyObject pyKitItem) {
        Iterator<PyObject> discountObjectsIterator = new JavaPythonProxy(pyDiscount).getIterable("objects");
        while (discountObjectsIterator.hasNext()) {
            PyObject discountObject = discountObjectsIterator.next();
            if (!discountObject.getType().getName().equals("Kit")) continue;
            int idxItem = 0;
            Iterator<PyObject> kitItemsIterator = new JavaPythonProxy(discountObject).getIterable("items");
            while (kitItemsIterator.hasNext()) {
                PyObject kitItem = kitItemsIterator.next();
                if (kitItem.equals((Object)pyKitItem)) {
                    return (DiscountObjectKitItem)((DiscountObjectKit)discount.getDiscountObject()).getListKitItems().get(idxItem);
                }
                ++idxItem;
            }
        }
        return null;
    }

    private static DiscountKitObjectItem findDiscountKitObjectItem(Discount discount, PyObject pyDiscount, PyObject pyKitItem) {
        Iterator<PyObject> discountObjectsIterator = new JavaPythonProxy(pyDiscount).getIterable("objects");
        while (discountObjectsIterator.hasNext()) {
            PyObject discountObject = discountObjectsIterator.next();
            if (!discountObject.getType().getName().equals("KitObject")) continue;
            int idxItem = 0;
            Iterator<PyObject> kitItemsIterator = new JavaPythonProxy(discountObject).getIterable("items");
            while (kitItemsIterator.hasNext()) {
                PyObject kitItem = kitItemsIterator.next();
                if (kitItem.equals((Object)pyKitItem)) {
                    return (DiscountKitObjectItem)((DiscountKitObject)discount.getDiscountObject()).getListKitItems().get(idxItem);
                }
                ++idxItem;
            }
        }
        return null;
    }

    private static DiscountRate createDiscountRate(Discount discount, PyObject pyDiscount, PyObject pyDiscountRate) {
        PythonInterpreter interpreter = PythonInterpreterFactory.resolveInterpreter();
        interpreter.set("rate", pyDiscountRate);
        interpreter.exec("convertedRate = rate.convert()");
        PyObject pyConvertedDiscountRate = interpreter.get("convertedRate");
        DiscountRatePercent discountRate = null;
        JavaPythonProxy proxyDiscountRate = new JavaPythonProxy(pyConvertedDiscountRate);
        String pyType = pyDiscountRate.getType().getName();
        if (pyType.equalsIgnoreCase("PercentDiscountRate")) {
            discountRate = new DiscountRatePercent();
            discountRate.setDiscountValue((Object)new BigDecimal(proxyDiscountRate.getString("value")));
        } else if (pyType.equalsIgnoreCase("SumDiscountRate")) {
            discountRate = new DiscountRateSum(BigDecimal.ZERO);
            discountRate.setDiscountValue((Object)new BigDecimal(proxyDiscountRate.getString("value")));
        } else if (pyType.equalsIgnoreCase("CalculateDiscountRate")) {
            discountRate = new DiscountRateCalculate("test", "percent");
            discountRate.setDiscountValue((Object)proxyDiscountRate.getString("value"));
            discountRate.setDiscountRateType(proxyDiscountRate.getString("type"));
        } else if (pyType.equalsIgnoreCase("IndexDiscountRate")) {
            discountRate = new DiscountRateIndex();
            discountRate.setDiscountValue((Object)Integer.valueOf(proxyDiscountRate.getString("value")));
        } else if (pyType.equalsIgnoreCase("PriceDiscountRate")) {
            discountRate = new DiscountRatePrice(BigDecimal.ZERO);
            discountRate.setDiscountValue((Object)new BigDecimal(proxyDiscountRate.getString("value")));
        } else if (pyType.equalsIgnoreCase("KitDiscountRate")) {
            if (discount.getDiscountObject() instanceof DiscountKitObject) {
                discountRate = new DiscountRateKitObject();
            } else if (discount.getDiscountObject() instanceof DiscountObjectKit) {
                discountRate = new DiscountRateKit();
            }
            Iterator<PyObject> items = proxyDiscountRate.getIterable("items");
            if (items.hasNext()) {
                DiscountRateKitItem rateKitItem;
                PyObject item = items.next();
                JavaPythonProxy itemProxy = new JavaPythonProxy(item);
                PyObject kitItem = itemProxy.getObject("kitItem");
                if (kitItem.getType().getName().equals("KitItem")) {
                    rateKitItem = new DiscountRateKitItem();
                    rateKitItem.setDiscountRate(DiscountSystemFromYaml.createDiscountRate(discount, pyDiscount, itemProxy.getObject("discountRate")));
                    rateKitItem.setDiscountObjectKitItem(DiscountSystemFromYaml.findDiscountObjectKitItem(discount, pyDiscount, itemProxy.getObject("kitItem")));
                    ((DiscountRateKit)discountRate).getKitItems().add(rateKitItem);
                    while (items.hasNext()) {
                        item = items.next();
                        rateKitItem = new DiscountRateKitItem();
                        itemProxy = new JavaPythonProxy(item);
                        rateKitItem.setDiscountRate(DiscountSystemFromYaml.createDiscountRate(discount, pyDiscount, itemProxy.getObject("discountRate")));
                        rateKitItem.setDiscountObjectKitItem(DiscountSystemFromYaml.findDiscountObjectKitItem(discount, pyDiscount, itemProxy.getObject("kitItem")));
                        ((DiscountRateKit)discountRate).getKitItems().add(rateKitItem);
                    }
                }
                if (kitItem.getType().getName().equals("KitObjectItem")) {
                    rateKitItem = new DiscountRateKitObjectItem();
                    rateKitItem.setDiscountRate(DiscountSystemFromYaml.createDiscountRate(discount, pyDiscount, itemProxy.getObject("discountRate")));
                    rateKitItem.setDiscountKitObjectItem(DiscountSystemFromYaml.findDiscountKitObjectItem(discount, pyDiscount, itemProxy.getObject("kitItem")));
                    ((DiscountRateKitObject)discountRate).getKitItems().add(rateKitItem);
                    while (items.hasNext()) {
                        item = items.next();
                        rateKitItem = new DiscountRateKitObjectItem();
                        itemProxy = new JavaPythonProxy(item);
                        rateKitItem.setDiscountRate(DiscountSystemFromYaml.createDiscountRate(discount, pyDiscount, itemProxy.getObject("discountRate")));
                        rateKitItem.setDiscountKitObjectItem(DiscountSystemFromYaml.findDiscountKitObjectItem(discount, pyDiscount, itemProxy.getObject("kitItem")));
                        ((DiscountRateKitObject)discountRate).getKitItems().add(rateKitItem);
                    }
                }
            }
        }
        PythonInterpreterFactory.releaseInterpreter(interpreter);
        return discountRate;
    }

    public static DiscountCampaign createDiscountCampaign(PyObject pyDiscountCampaign) {
        String endBonusesIntervalValue;
        PythonInterpreter interpreter = PythonInterpreterFactory.resolveInterpreter();
        interpreter.set("campaign", pyDiscountCampaign);
        interpreter.exec("convertedCampaign = campaign.convert()");
        PyObject pyConvertedCampaign = interpreter.get("convertedCampaign");
        JavaPythonProxy proxyDiscountCampaign = new JavaPythonProxy(pyConvertedCampaign);
        DiscountCampaign discountCampaign = new DiscountCampaign();
        discountCampaign.setName(proxyDiscountCampaign.getString("name"));
        discountCampaign.setDiscountInteraction(proxyDiscountCampaign.getString("interactionType"));
        Date temp = proxyDiscountCampaign.getDate("beginDate");
        discountCampaign.setBeginDate(temp);
        temp = proxyDiscountCampaign.getDate("endDate");
        discountCampaign.setEndDate(temp);
        discountCampaign.setId(Long.valueOf(proxyDiscountCampaign.getString("id")));
        discountCampaign.setActive(Boolean.valueOf(proxyDiscountCampaign.getString("active")));
        String priority = proxyDiscountCampaign.getString("priority");
        discountCampaign.setPriority(priority == null ? null : Integer.valueOf(priority));
        if (proxyDiscountCampaign.getPyObject().__findattr__("checkedTags") != null && proxyDiscountCampaign.getPyObject().__findattr__("checkedTags").__nonzero__()) {
            for (Object pyGroup : (PyList)proxyDiscountCampaign.getObject("checkedTags")) {
                ArrayList<String> group = new ArrayList<String>();
                for (Object tagId : (PyList)pyGroup) {
                    group.add((String)tagId);
                }
                discountCampaign.getCheckedTags().add(group);
            }
        }
        if (proxyDiscountCampaign.getPyObject().__findattr__("tagsIsAllowed") != null) {
            discountCampaign.setTagsIsAllowed(Boolean.valueOf(proxyDiscountCampaign.getString("tagsIsAllowed")).booleanValue());
        }
        Iterator<PyObject> discounts = proxyDiscountCampaign.getIterable("discounts");
        String weight = proxyDiscountCampaign.getString("weight");
        if (weight == null || weight.equals("None")) {
            discountCampaign.setWeightNotSet(true);
        } else {
            discountCampaign.setWeightNotSet(false);
            discountCampaign.setWeight(Integer.parseInt(weight));
        }
        String beginBonusesIntervalCondition = proxyDiscountCampaign.getString("beginBonusesIntervalCondition");
        discountCampaign.setBeginBonusesIntervalCondition(beginBonusesIntervalCondition);
        String endBonusesIntervalCondition = proxyDiscountCampaign.getString("endBonusesIntervalCondition");
        discountCampaign.setEndBonusesIntervalCondition(endBonusesIntervalCondition);
        Date beginRangeDate = proxyDiscountCampaign.getDate("beginRangeDate");
        discountCampaign.setBeginRangeDate(beginRangeDate);
        Date endRangeDate = proxyDiscountCampaign.getDate("endRangeDate");
        discountCampaign.setEndRangeDate(endRangeDate);
        String beginBonusesIntervalValue = proxyDiscountCampaign.getString("beginBonusesIntervalValue");
        if (endBonusesIntervalCondition != null) {
            discountCampaign.setBeginBonusesIntervalValue(Integer.parseInt(beginBonusesIntervalValue));
        }
        if ((endBonusesIntervalValue = proxyDiscountCampaign.getString("endBonusesIntervalValue")) != null) {
            discountCampaign.setEndBonusesIntervalValue(Integer.parseInt(endBonusesIntervalValue));
        }
        String beginDateWithBeginNextMetric = proxyDiscountCampaign.getString("beginDateWithBeginNextMetric");
        discountCampaign.setBeginDateWithBeginNextMetric(beginDateWithBeginNextMetric);
        String beginBonusesIntervalMetric = proxyDiscountCampaign.getString("beginBonusesIntervalMetric");
        discountCampaign.setBeginBonusesIntervalMetric(beginBonusesIntervalMetric);
        String endBonusesIntervalMetric = proxyDiscountCampaign.getString("endBonusesIntervalMetric");
        discountCampaign.setEndBonusesIntervalMetric(endBonusesIntervalMetric);
        String beginDateWithBeginCurrentMetric = proxyDiscountCampaign.getString("beginDateWithBeginCurrentMetric");
        discountCampaign.setBeginDateWithBeginCurrentMetric(beginDateWithBeginCurrentMetric);
        String beginBonusesDateCalculate = proxyDiscountCampaign.getString("beginBonusesDateCalculate");
        discountCampaign.setBeginBonusesDateCalculate(beginBonusesDateCalculate);
        String endBonusesDateCalculate = proxyDiscountCampaign.getString("endBonusesDateCalculate");
        discountCampaign.setEndBonusesDateCalculate(endBonusesDateCalculate);
        discountCampaign.setManualActivate(Boolean.valueOf(proxyDiscountCampaign.getString("manualActivate")));
        String beginTime = proxyDiscountCampaign.getString("beginTime");
        discountCampaign.setBeginTime(beginTime);
        String endTime = proxyDiscountCampaign.getString("endTime");
        discountCampaign.setEndTime(endTime);
        ArrayList<Integer> daysOfWeek = new ArrayList<Integer>();
        if (proxyDiscountCampaign.getPyObject().__findattr__("daysOfWeek") != null) {
            for (Object day : (PyList)proxyDiscountCampaign.getObject("daysOfWeek")) {
                String d = day.toString();
                daysOfWeek.add(Integer.valueOf(d));
            }
        }
        discountCampaign.setDaysOfWeek(daysOfWeek);
        TreeSet<String> labels = new TreeSet<String>();
        PyObject labs = proxyDiscountCampaign.getPyObject().__findattr__("labels");
        if (labs == null || labs.toString().equals("None")) {
            discountCampaign.setLabels(null);
        } else {
            for (Object label : (PyList)proxyDiscountCampaign.getObject("labels")) {
                String lab = label.toString();
                labels.add(lab);
            }
            if (!labels.isEmpty()) {
                discountCampaign.setLabels(labels);
            }
        }
        TreeSet<String> qualifiers = new TreeSet<String>();
        PyObject pyAttrQualifier = proxyDiscountCampaign.getPyObject().__findattr__("qualifiers");
        if (pyAttrQualifier == null || pyAttrQualifier.toString().equals("None")) {
            discountCampaign.setQualifiers(null);
        } else {
            for (Object qualifier : (PySet)proxyDiscountCampaign.getObject("qualifiers")) {
                String key = qualifier.toString();
                qualifiers.add(key);
            }
            if (!qualifiers.isEmpty()) {
                discountCampaign.setQualifiers(qualifiers);
            }
        }
        while (discounts.hasNext()) {
            PyObject discount = discounts.next();
            Discount discountConverted = DiscountSystemFromYaml.createDiscount(discount);
            if (discountConverted == null) continue;
            discountCampaign.addDiscount(discountConverted);
        }
        PythonInterpreterFactory.releaseInterpreter(interpreter);
        return discountCampaign;
    }

    private static DiscountCampaignGroup createDiscountCampaignGroup(PyObject pyCampaignGroup, DiscountCampaignGroup parent) {
        PythonInterpreter interpreter = PythonInterpreterFactory.resolveInterpreter();
        interpreter.set("campaignGroup", pyCampaignGroup);
        interpreter.exec("convertedCampaignGroup = campaignGroup.convert()");
        PyObject pyConvertedCampaignGroup = interpreter.get("convertedCampaignGroup");
        JavaPythonProxy proxyCampaignGroup = new JavaPythonProxy(pyConvertedCampaignGroup);
        DiscountCampaignGroup discountCampaignGroup = new DiscountCampaignGroup("2.1");
        discountCampaignGroup.setName(proxyCampaignGroup.getString("name"));
        discountCampaignGroup.setCampaignInteraction(proxyCampaignGroup.getString("interactionType"));
        Iterator<PyObject> subGroups = proxyCampaignGroup.getIterable("childGroups");
        while (subGroups.hasNext()) {
            PyObject subGroup = subGroups.next();
            discountCampaignGroup.addSubGroup(DiscountSystemFromYaml.createDiscountCampaignGroup(subGroup, discountCampaignGroup));
        }
        Iterator<PyObject> campaigns = proxyCampaignGroup.getIterable("discountCampaigns");
        while (campaigns.hasNext()) {
            PyObject campaign = campaigns.next();
            DiscountCampaign discountCampaign = DiscountSystemFromYaml.createDiscountCampaign(campaign);
            discountCampaignGroup.addDiscountCampaign(discountCampaign);
        }
        if (parent != null) {
            discountCampaignGroup.setParent((Named)parent);
        }
        discountCampaignGroup.setVersion("2.1");
        String priority = proxyCampaignGroup.getString("priority");
        discountCampaignGroup.setPriority(priority == null ? null : Integer.valueOf(priority));
        PythonInterpreterFactory.releaseInterpreter(interpreter);
        return discountCampaignGroup;
    }

    private static DiscountSystem createDiscountSystem(PyObject pyCampaignGroup) {
        DiscountSystem discountSystem = new DiscountSystem();
        if (pyCampaignGroup == null) {
            return discountSystem;
        }
        discountSystem.setCampaignGroup(DiscountSystemFromYaml.createDiscountCampaignGroup(pyCampaignGroup, null));
        return discountSystem;
    }

    public static PyObject initialDiscountCampaignGroupFromYaml(String dsAsYaml) {
        return DiscountSystemFromYaml.getPyDiscountModelFromYaml(dsAsYaml);
    }

    private static PyObject getPyDiscountModelFromYaml(String discountModelAsYaml) {
        PythonInterpreter interpreter = PythonInterpreterFactory.resolveInterpreter();
        PyObject pyDiscountModel = null;
        interpreter.set("discountModelAsYaml", (Object)discountModelAsYaml);
        if (!discountModelAsYaml.isEmpty()) {
            interpreter.exec("initialCampaignGroup = yaml.load(discountModelAsYaml)");
            pyDiscountModel = interpreter.get("initialCampaignGroup");
        }
        PythonInterpreterFactory.releaseInterpreter(interpreter);
        return pyDiscountModel;
    }

    private static DiscountSystem createDiscountSystemFromYaml(String dsYaml) {
        PyObject initialDiscountCampaignGroup = DiscountSystemFromYaml.initialDiscountCampaignGroupFromYaml(dsYaml);
        return DiscountSystemFromYaml.createDiscountSystem(initialDiscountCampaignGroup);
    }

    public static DiscountSystem getDiscountSystem(String discountSystemJson) {
        return DiscountSystemFromYaml.createDiscountSystemFromYaml(discountSystemJson);
    }

    public static List<AbstractDiscountModel> getDiscountModel(String discountModelAsYaml) throws Exception {
        ArrayList<AbstractDiscountModel> discountModels = new ArrayList<AbstractDiscountModel>();
        PyObject pyDiscountModels = DiscountSystemFromYaml.getPyDiscountModelFromYaml(discountModelAsYaml);
        if (pyDiscountModels instanceof PyList) {
            PyList pyList = (PyList)pyDiscountModels;
            for (PyObject pyDiscountModel : pyList.getArray()) {
                String className = pyDiscountModel.getType().getName();
                if (className.equals("DiscountCampaignGroup")) {
                    discountModels.add((AbstractDiscountModel)DiscountSystemFromYaml.createDiscountCampaignGroup(pyDiscountModel, null));
                    continue;
                }
                if (className.equals("DiscountCampaign")) {
                    discountModels.add((AbstractDiscountModel)DiscountSystemFromYaml.createDiscountCampaign(pyDiscountModel));
                    continue;
                }
                if (className.equals("Discount")) {
                    discountModels.add((AbstractDiscountModel)DiscountSystemFromYaml.createDiscount(pyDiscountModel));
                    continue;
                }
                throw new Exception("Can't load discount from file, file is corrupt");
            }
        }
        return discountModels;
    }

    private DiscountSystemFromYaml() {
    }

    private static Coupon createCoupon(PyObject pyCoupon) {
        JavaPythonProxy proxyCoupon = new JavaPythonProxy(pyCoupon);
        Coupon coupon = new Coupon();
        coupon.setNumber(proxyCoupon.getString("number"));
        coupon.setReport(proxyCoupon.getString("report"));
        coupon.setType(proxyCoupon.getString("type"));
        coupon.setPrefix(proxyCoupon.getString("prefix"));
        return coupon;
    }

    private static Counter createCounter(PyObject pyCounter, Discount discount) {
        JavaPythonProxy proxyCounter = new JavaPythonProxy(pyCounter);
        Counter counter = new Counter();
        counter.setCounterId(proxyCounter.getString("counterId"));
        counter.setRate(DiscountSystemFromYaml.createDiscountRate(discount, pyCounter, proxyCounter.getObject("rate")));
        String position = proxyCounter.getString("position");
        counter.setPosition(position == null ? null : Boolean.valueOf(Boolean.parseBoolean(position)));
        return counter;
    }

    private static Gift createGift(PyObject pyGift) {
        JavaPythonProxy proxyGift = new JavaPythonProxy(pyGift);
        Gift gift = new Gift();
        gift.setCatalogCode(Integer.valueOf(proxyGift.getString("catalogCode")));
        gift.setMinCount(Integer.valueOf(proxyGift.getString("minCount") == null ? 0 : Integer.valueOf(proxyGift.getString("minCount"))));
        gift.setCount(Integer.valueOf(proxyGift.getString("count")));
        gift.setCanCancel(Boolean.valueOf(proxyGift.getString("canCancel")));
        gift.setAsGoods(Boolean.valueOf(proxyGift.getString("asGoods")));
        return gift;
    }

    private static Report createReport(PyObject pyReport) {
        JavaPythonProxy proxyReport = new JavaPythonProxy(pyReport);
        Report report = new Report();
        report.setType(proxyReport.getString("type"));
        report.setValue(proxyReport.getString("value"));
        return report;
    }
}

