/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.GroupInfo;

public class GroupsRestClient {
    private static final String GROUP_URL = "groups";
    private final RestInvokerManager restInvokerManager;

    public GroupsRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public Long countGroups() {
        return this.restInvokerManager.getRestInvoker().invokeGet("groups/count", Long.class);
    }

    public Boolean existsGroup(String id) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("groups/{0}/exists", id), Boolean.class);
    }

    public List<GroupInfo> getGroups() {
        ParameterizedTypeReference<List<GroupInfo>> returnTypeRef = new ParameterizedTypeReference<List<GroupInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(GROUP_URL, returnTypeRef);
    }

    public List<GroupInfo> getRootGroups() {
        ParameterizedTypeReference<List<GroupInfo>> returnTypeRef = new ParameterizedTypeReference<List<GroupInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("groups?rootGroups=true", returnTypeRef);
    }

    public List<GroupInfo> getGroupsByGroupCode(String groupId) {
        ParameterizedTypeReference<List<GroupInfo>> returnTypeRef = new ParameterizedTypeReference<List<GroupInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("groups?groupId={0}", groupId), returnTypeRef);
    }

    public GroupInfo getGroup(String groupId) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("groups/{0}", groupId), GroupInfo.class);
    }
}

