/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.providers.discountsystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import su.artix.cashserver.core.cashregistry.domain.ShopGroupLabel;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.discountmanager.providers.discountsystem.CachedTags;

public class TagContentProvider
implements ITreeContentProvider {
    private List<ShopLabel> allTags = new ArrayList<ShopLabel>();
    private List<ShopLabel> currentTags = new ArrayList<ShopLabel>();
    private boolean include = true;
    private boolean only = false;

    public TagContentProvider(boolean include, boolean only) {
        this.include = include;
        this.allTags = CachedTags.getAllTags();
        this.only = only;
    }

    private void updateTags(List<ShopLabel> tagIds) {
        System.out.println(tagIds);
        ArrayList<ShopLabel> tmpTags = new ArrayList<ShopLabel>();
        if (!this.include && !this.only) {
            tmpTags.addAll(this.allTags);
        }
        ArrayList<ShopLabel> readyTagIds = new ArrayList<ShopLabel>();
        HashMap<String, ShopGroupLabel> knownGroups = new HashMap<String, ShopGroupLabel>();
        block0: for (ShopLabel tag : this.allTags) {
            for (ShopLabel tagId : tagIds) {
                if (this.only) {
                    if (!tag.getCode().equals(tagId.getCode())) continue;
                    tmpTags.add(tag);
                    readyTagIds.add(tagId);
                    knownGroups.put(tagId.getGroup(), tag.getShopGroupLabel());
                    continue;
                }
                if (!tag.getCode().equals(tagId.getCode())) continue;
                if (this.include) {
                    tmpTags.add(tag);
                    readyTagIds.add(tagId);
                } else {
                    tmpTags.remove(tag);
                }
                knownGroups.put(tagId.getGroup(), tag.getShopGroupLabel());
                continue block0;
            }
        }
        if ((this.include || this.only) && tagIds.size() != readyTagIds.size()) {
            ArrayList<ShopLabel> notAttachedTagIds = new ArrayList<ShopLabel>();
            notAttachedTagIds.addAll(tagIds);
            notAttachedTagIds.removeAll(readyTagIds);
            for (ShopLabel tagId : notAttachedTagIds) {
                ShopLabel tag = new ShopLabel();
                tag.setCode(tagId.getCode());
                tag.setName(tagId.getCode());
                tag.setDummy(true);
                String key = tagId.getGroup();
                ShopGroupLabel tagType = (ShopGroupLabel)knownGroups.get(key);
                if (tagType == null) {
                    tagType = new ShopGroupLabel();
                    tagType.setName("\u041d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u043c\u0435\u0442\u043a\u0438 " + key);
                    tagType.setId(key);
                    knownGroups.put(key, tagType);
                }
                tag.setShopGroupLabel(tagType);
                tmpTags.add(tag);
            }
        }
        this.currentTags = tmpTags;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer paramViewer, Object oldObj, Object newObj) {
    }

    public Object[] getElements(Object paramObject) {
        this.updateTags((ArrayList)paramObject);
        HashSet<ShopGroupLabel> elements = new HashSet<ShopGroupLabel>();
        for (ShopLabel tag : this.currentTags) {
            if (tag.getShopGroupLabel() == null) continue;
            elements.add(tag.getShopGroupLabel());
        }
        return elements.toArray();
    }

    public Object[] getChildren(Object paramObject) {
        if (paramObject instanceof ShopGroupLabel) {
            ArrayList<ShopLabel> childTags = new ArrayList<ShopLabel>();
            for (ShopLabel tag : this.currentTags) {
                if (tag.getShopGroupLabel() == null || !tag.getShopGroupLabel().equals(paramObject)) continue;
                childTags.add(tag);
            }
            return childTags.toArray();
        }
        return null;
    }

    public Object getParent(Object paramObject) {
        return null;
    }

    public boolean hasChildren(Object paramObject) {
        if (paramObject instanceof ShopGroupLabel) {
            for (ShopLabel tag : this.currentTags) {
                if (tag.getShopGroupLabel() == null || !tag.getShopGroupLabel().equals(paramObject)) continue;
                return true;
            }
        }
        return false;
    }

    public List<List<String>> getGroupingTags() {
        ArrayList<List<String>> rez = new ArrayList<List<String>>();
        HashMap groupTags = new HashMap();
        for (ShopLabel tag : this.currentTags) {
            String type = null;
            ShopGroupLabel tagType = tag.getShopGroupLabel();
            if (tagType != null) {
                type = tagType.getName();
            }
            if (type == null) continue;
            if (groupTags.get(type) == null) {
                groupTags.put(type, new HashSet());
            }
            ((Set)groupTags.get(type)).add(tag.getCode());
        }
        for (Set set : groupTags.values()) {
            ArrayList<String> gr = new ArrayList<String>();
            for (String st : set) {
                gr.add(st);
            }
            rez.add(gr);
        }
        return rez;
    }

    public List<ShopLabel> getAllTags() {
        ArrayList<ShopLabel> tags = new ArrayList<ShopLabel>();
        for (ShopLabel tag : this.allTags) {
            tags.add(tag);
        }
        return tags;
    }
}

